/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncResultsService;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.search.AsyncSearchTask;

public class TransportGetAsyncSearchAction
extends HandledTransportAction<GetAsyncResultRequest, AsyncSearchResponse> {
    private final AsyncResultsService<AsyncSearchTask, AsyncSearchResponse> resultsService;
    private final TransportService transportService;

    @Inject
    public TransportGetAsyncSearchAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays) {
        super("indices:data/read/async_search/get", transportService, actionFilters, GetAsyncResultRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.resultsService = TransportGetAsyncSearchAction.createResultsService(transportService, clusterService, registry, client, threadPool, bigArrays);
    }

    static AsyncResultsService<AsyncSearchTask, AsyncSearchResponse> createResultsService(TransportService transportService, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays) {
        AsyncTaskIndexService store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", AsyncSearchResponse::new, registry, bigArrays);
        return new AsyncResultsService(store, true, AsyncSearchTask.class, AsyncSearchTask::addCompletionListener, transportService.getTaskManager(), clusterService);
    }

    protected void doExecute(Task task, GetAsyncResultRequest request, ActionListener<AsyncSearchResponse> listener) {
        DiscoveryNode node = this.resultsService.getNode(request.getId());
        if (node == null || this.resultsService.isLocalNode(node)) {
            this.resultsService.retrieveResult(request, listener);
        } else {
            this.transportService.sendRequest(node, "indices:data/read/async_search/get", (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, AsyncSearchResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE));
        }
    }
}

