/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.openai.OpenAiModel;
import org.elasticsearch.xpack.inference.services.openai.OpenAiServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class OpenAiEmbeddingsModel
extends OpenAiModel {
    public OpenAiEmbeddingsModel(String modelId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets) {
        this(modelId, taskType, service, OpenAiServiceSettings.fromMap(serviceSettings), OpenAiEmbeddingsTaskSettings.fromMap(taskSettings), DefaultSecretSettings.fromMap(secrets));
    }

    OpenAiEmbeddingsModel(String modelId, TaskType taskType, String service, OpenAiServiceSettings serviceSettings, OpenAiEmbeddingsTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(modelId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets));
    }

    private OpenAiEmbeddingsModel(OpenAiEmbeddingsModel originalModel, OpenAiEmbeddingsTaskSettings taskSettings) {
        super(new ModelConfigurations(originalModel.getConfigurations().getModelId(), originalModel.getConfigurations().getTaskType(), originalModel.getConfigurations().getService(), (ServiceSettings)originalModel.getServiceSettings(), (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)originalModel.getSecretSettings()));
    }

    public OpenAiEmbeddingsModel(OpenAiEmbeddingsModel originalModel, OpenAiServiceSettings serviceSettings) {
        super(new ModelConfigurations(originalModel.getConfigurations().getModelId(), originalModel.getConfigurations().getTaskType(), originalModel.getConfigurations().getService(), (ServiceSettings)serviceSettings, (TaskSettings)originalModel.getTaskSettings()), new ModelSecrets((SecretSettings)originalModel.getSecretSettings()));
    }

    public OpenAiServiceSettings getServiceSettings() {
        return (OpenAiServiceSettings)super.getServiceSettings();
    }

    public OpenAiEmbeddingsTaskSettings getTaskSettings() {
        return (OpenAiEmbeddingsTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(OpenAiActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    public OpenAiEmbeddingsModel overrideWith(Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return this;
        }
        OpenAiEmbeddingsRequestTaskSettings requestTaskSettings = OpenAiEmbeddingsRequestTaskSettings.fromMap(taskSettings);
        return new OpenAiEmbeddingsModel(this, this.getTaskSettings().overrideWith(requestTaskSettings));
    }
}

