/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.common.SimilarityMeasure;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSenderFactory;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiModel;
import org.elasticsearch.xpack.inference.services.openai.OpenAiServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsModel;

public class OpenAiService
extends SenderService {
    public static final String NAME = "openai";

    public OpenAiService(SetOnce<HttpRequestSenderFactory> factory, SetOnce<ServiceComponents> serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public OpenAiModel parseRequestConfig(String modelId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        OpenAiModel model = OpenAiService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME));
        ServiceUtils.throwIfNotEmptyMap(config, NAME);
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
        ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OpenAiModel createModel(String modelId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        switch (taskType) {
            case TEXT_EMBEDDING: {
                return new OpenAiEmbeddingsModel(modelId, taskType, NAME, serviceSettings, taskSettings, secretSettings);
            }
            default: {
                throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    public OpenAiModel parsePersistedConfigWithSecrets(String modelId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return OpenAiService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(modelId, NAME));
    }

    public OpenAiModel parsePersistedConfig(String modelId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        return OpenAiService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(modelId, NAME));
    }

    @Override
    public void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof OpenAiModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        OpenAiModel openAiModel = (OpenAiModel)model;
        OpenAiActionCreator actionCreator = new OpenAiActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = openAiModel.accept(actionCreator, taskSettings);
        action.execute(input, listener);
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof OpenAiEmbeddingsModel) {
            OpenAiEmbeddingsModel embeddingsModel = (OpenAiEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)ActionListener.wrap(size -> listener.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private OpenAiEmbeddingsModel updateModelWithEmbeddingDetails(OpenAiEmbeddingsModel model, int embeddingSize) {
        OpenAiServiceSettings serviceSettings = new OpenAiServiceSettings(model.getServiceSettings().uri(), model.getServiceSettings().organizationId(), SimilarityMeasure.DOT_PRODUCT, (Integer)embeddingSize, model.getServiceSettings().maxInputTokens());
        return new OpenAiEmbeddingsModel(model, serviceSettings);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_OPENAI_ADDED;
    }
}

