/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.inference.common.SimilarityMeasure;

public class ServiceUtils {
    private static final String TEST_EMBEDDING_INPUT = "how big";

    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type) {
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new ElasticsearchStatusException("field [{}] is not of the expected type. The value [{}] cannot be converted to a [{}]", RestStatus.BAD_REQUEST, new Object[]{key, o, type.getSimpleName()});
    }

    public static Map<String, Object> removeFromMapOrThrowIfNull(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{fieldName});
        }
        return value;
    }

    public static String removeStringOrThrowIfNull(Map<String, Object> sourceMap, String key) {
        String value = ServiceUtils.removeAsType(sourceMap, key, String.class);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{key});
        }
        return value;
    }

    public static void throwIfNotEmptyMap(Map<String, Object> settingsMap, String serviceName) {
        if (settingsMap != null && !settingsMap.isEmpty()) {
            throw ServiceUtils.unknownSettingsError(settingsMap, serviceName);
        }
    }

    public static ElasticsearchStatusException unknownSettingsError(Map<String, Object> config, String serviceName) {
        return new ElasticsearchStatusException("Model configuration contains settings [{}] unknown to the [{}] service", RestStatus.BAD_REQUEST, new Object[]{config, serviceName});
    }

    public static String missingSettingErrorMsg(String settingName, String scope) {
        return Strings.format((String)"[%s] does not contain the required setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static String invalidUrlErrorMsg(String url, String settingName, String settingScope) {
        return Strings.format((String)"[%s] Invalid url [%s] received for field [%s]", (Object[])new Object[]{settingScope, url, settingName});
    }

    public static String mustBeNonEmptyString(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty string. [%s] must be a non-empty string", (Object[])new Object[]{scope, settingName});
    }

    public static URI convertToUri(String url, String settingName, String settingScope, ValidationException validationException) {
        try {
            return ServiceUtils.createUri(url);
        }
        catch (IllegalArgumentException ignored) {
            validationException.addValidationError(ServiceUtils.invalidUrlErrorMsg(url, settingName, settingScope));
            return null;
        }
    }

    public static URI createUri(String url) throws IllegalArgumentException {
        Objects.requireNonNull(url);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(Strings.format((String)"unable to parse url [%s]", (Object[])new Object[]{url}), e);
        }
    }

    public static SecureString extractRequiredSecureString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String requiredField = ServiceUtils.extractRequiredString(map, settingName, scope, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return new SecureString(Objects.requireNonNull(requiredField).toCharArray());
    }

    public static SimilarityMeasure extractSimilarity(Map<String, Object> map, String scope, ValidationException validationException) {
        String similarity = ServiceUtils.extractOptionalString(map, "similarity", scope, validationException);
        if (similarity != null) {
            try {
                return SimilarityMeasure.fromString(similarity);
            }
            catch (IllegalArgumentException iae) {
                validationException.addValidationError("[" + scope + "] Unknown similarity measure [" + similarity + "]");
            }
        }
        return null;
    }

    public static String extractRequiredString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String requiredField = ServiceUtils.removeAsType(map, settingName, String.class);
        if (requiredField == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (requiredField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return requiredField;
    }

    public static String extractOptionalString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String optionalField = ServiceUtils.removeAsType(map, settingName, String.class);
        if (optionalField != null && optionalField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return optionalField;
    }

    public static String parsePersistedConfigErrorMsg(String modelId, String serviceName) {
        return Strings.format((String)"Failed to parse stored model [%s] for [%s] service, please delete and add the service again", (Object[])new Object[]{modelId, serviceName});
    }

    public static ElasticsearchStatusException createInvalidModelException(Model model) {
        return new ElasticsearchStatusException(Strings.format((String)"The internal model was invalid, please delete the service [%s] with id [%s] and add it again.", (Object[])new Object[]{model.getConfigurations().getService(), model.getConfigurations().getModelId()}), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    public static void getEmbeddingSize(Model model, InferenceService service, ActionListener<Integer> listener) {
        assert (model.getTaskType() == TaskType.TEXT_EMBEDDING);
        service.infer(model, List.of(TEST_EMBEDDING_INPUT), Map.of(), ActionListener.wrap(r -> {
            if (r instanceof TextEmbeddingResults) {
                TextEmbeddingResults embeddingResults = (TextEmbeddingResults)r;
                if (embeddingResults.embeddings().isEmpty()) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Could not determine embedding size, no embeddings were returned in test call", RestStatus.BAD_REQUEST, new Object[0]));
                } else {
                    listener.onResponse((Object)((TextEmbeddingResults.Embedding)embeddingResults.embeddings().get(0)).values().size());
                }
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException("Could not determine embedding size. Expected a result of type [text_embedding_service_results] got [" + r.getWriteableName() + "]", RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

