/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.xcontent.ToXContent;

public class DriverProfile
implements Writeable,
ChunkedToXContentObject {
    private final List<DriverStatus.OperatorStatus> operators;

    public DriverProfile(List<DriverStatus.OperatorStatus> operators) {
        this.operators = operators;
    }

    public DriverProfile(StreamInput in) throws IOException {
        this.operators = in.readCollectionAsImmutableList(DriverStatus.OperatorStatus::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.operators);
    }

    List<DriverStatus.OperatorStatus> operators() {
        return this.operators;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.array((String)"operators", this.operators.iterator()), ChunkedToXContentHelper.endObject()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverProfile that = (DriverProfile)o;
        return Objects.equals(this.operators, that.operators);
    }

    public int hashCode() {
        return Objects.hash(this.operators);
    }
}

