/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.TextDocValuesField;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class TextValueSource
extends ValuesSource.Bytes {
    private final IndexFieldData<?> indexFieldData;

    public TextValueSource(IndexFieldData<?> indexFieldData) {
        this.indexFieldData = indexFieldData;
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext leafReaderContext) {
        String fieldName = this.indexFieldData.getFieldName();
        LeafFieldData fieldData = this.indexFieldData.load(leafReaderContext);
        return ((TextDocValuesFieldWrapper)fieldData.getScriptFieldFactory(fieldName)).bytesValues();
    }

    static final class TextDocValuesFieldWrapper
    extends TextDocValuesField {
        TextDocValuesFieldWrapper(SortedBinaryDocValues input, String name) {
            super(input, name);
        }

        SortedBinaryDocValues bytesValues() {
            return this.input;
        }
    }
}

