/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;

public final class LongArrayBlock
extends AbstractArrayBlock
implements LongBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayBlock.class);
    private final long[] values;

    public LongArrayBlock(long[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        this(values, positionCount, firstValueIndexes, nulls, mvOrdering, BlockFactory.getNonBreakingInstance());
    }

    public LongArrayBlock(long[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering, blockFactory);
        this.values = values;
    }

    @Override
    public LongVector asVector() {
        return null;
    }

    @Override
    public long getLong(int valueIndex) {
        return this.values[valueIndex];
    }

    @Override
    public LongBlock filter(int ... positions) {
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendLong(this.getLong(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendLong(this.getLong(first + c));
                }
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.mvOrdering(this.mvOrdering()).build();
            return longBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public LongBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(this.firstValueIndexes[this.getPositionCount()]);){
            for (int pos = 0; pos < this.getPositionCount(); ++pos) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int first = this.getFirstValueIndex(pos);
                int end = first + this.getValueCount(pos);
                for (int i = first; i < end; ++i) {
                    builder.appendLong(this.getLong(i));
                }
            }
            LongBlock longBlock = builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING).build();
            return longBlock;
        }
    }

    public static long ramBytesEstimated(long[] values, int[] firstValueIndexes, BitSet nullsMask) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((long[])values) + BlockRamUsageEstimator.sizeOf(firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(nullsMask);
    }

    public long ramBytesUsed() {
        return LongArrayBlock.ramBytesEstimated(this.values, this.firstValueIndexes, this.nullsMask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongBlock) {
            LongBlock that = (LongBlock)obj;
            return LongBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", values=" + Arrays.toString(this.values) + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed(), true);
    }
}

