/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.BitSet;
import org.elasticsearch.compute.data.AbstractBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Nullable;

abstract class AbstractArrayBlock
extends AbstractBlock {
    private final Block.MvOrdering mvOrdering;

    protected AbstractArrayBlock(int positionCount, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.mvOrdering = mvOrdering;
    }

    protected AbstractArrayBlock(int positionCount, @Nullable int[] firstValueIndexes, @Nullable BitSet nullsMask, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nullsMask, blockFactory);
        this.mvOrdering = mvOrdering;
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return this.firstValueIndexes != null;
    }

    @Override
    public final Block.MvOrdering mvOrdering() {
        return this.mvOrdering;
    }

    protected BitSet shiftNullsToExpandedPositions() {
        BitSet expanded = new BitSet(this.getTotalValueCount());
        int next = -1;
        while ((next = this.nullsMask.nextSetBit(next + 1)) != -1) {
            expanded.set(this.getFirstValueIndex(next));
        }
        return expanded;
    }
}

