/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;

class PercentileDoubleAggregator {
    PercentileDoubleAggregator() {
    }

    public static QuantileStates.SingleState initSingle(double percentile) {
        return new QuantileStates.SingleState(percentile);
    }

    public static void combine(QuantileStates.SingleState current, double v) {
        current.add(v);
    }

    public static void combineStates(QuantileStates.SingleState current, QuantileStates.SingleState state) {
        current.add(state);
    }

    public static void combineIntermediate(QuantileStates.SingleState state, BytesRef inValue) {
        state.add(inValue);
    }

    public static Block evaluateFinal(QuantileStates.SingleState state, DriverContext driverContext) {
        return state.evaluatePercentile(driverContext);
    }

    public static QuantileStates.GroupingState initGrouping(BigArrays bigArrays, double percentile) {
        return new QuantileStates.GroupingState(bigArrays, percentile);
    }

    public static void combine(QuantileStates.GroupingState state, int groupId, double v) {
        state.add(groupId, v);
    }

    public static void combineIntermediate(QuantileStates.GroupingState state, int groupId, BytesRef inValue) {
        state.add(groupId, inValue);
    }

    public static void combineStates(QuantileStates.GroupingState current, int currentGroupId, QuantileStates.GroupingState state, int statePosition) {
        current.add(currentGroupId, state.getOrNull(statePosition));
    }

    public static Block evaluateFinal(QuantileStates.GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.evaluatePercentile(selected, driverContext);
    }
}

