/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.HllStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;

public class CountDistinctDoubleAggregator {
    public static HllStates.SingleState initSingle(BigArrays bigArrays, int precision) {
        return new HllStates.SingleState(bigArrays, precision);
    }

    public static void combine(HllStates.SingleState current, double v) {
        current.collect(v);
    }

    public static void combineStates(HllStates.SingleState current, HllStates.SingleState state) {
        current.merge(0, (AbstractHyperLogLogPlusPlus)state.hll, 0);
    }

    public static void combineIntermediate(HllStates.SingleState current, BytesRef inValue) {
        current.merge(0, inValue, 0);
    }

    public static Block evaluateFinal(HllStates.SingleState state, DriverContext driverContext) {
        long result = state.cardinality();
        return LongBlock.newConstantBlockWith(result, 1, driverContext.blockFactory());
    }

    public static HllStates.GroupingState initGrouping(BigArrays bigArrays, int precision) {
        return new HllStates.GroupingState(bigArrays, precision);
    }

    public static void combine(HllStates.GroupingState current, int groupId, double v) {
        current.collect(groupId, v);
    }

    public static void combineIntermediate(HllStates.GroupingState current, int groupId, BytesRef inValue) {
        current.merge(groupId, inValue, 0);
    }

    public static void combineStates(HllStates.GroupingState current, int currentGroupId, HllStates.GroupingState state, int statePosition) {
        current.merge(currentGroupId, (AbstractHyperLogLogPlusPlus)state.hll, statePosition);
    }

    public static Block evaluateFinal(HllStates.GroupingState state, IntVector selected, DriverContext driverContext) {
        try (LongBlock.Builder builder = LongBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                long count = state.cardinality(group);
                builder.appendLong(count);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }
}

