/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.common.SimilarityMeasure;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class OpenAiServiceSettings
implements ServiceSettings {
    public static final String NAME = "openai_service_settings";
    public static final String ORGANIZATION = "organization_id";
    private final URI uri;
    private final String organizationId;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;

    public static OpenAiServiceSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        String organizationId = ServiceUtils.extractOptionalString(map, ORGANIZATION, "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        if (url == null) {
            return new OpenAiServiceSettings((URI)null, organizationId, similarity, dims, maxInputTokens);
        }
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiServiceSettings(uri, organizationId, similarity, dims, maxInputTokens);
    }

    public OpenAiServiceSettings(@Nullable URI uri, @Nullable String organizationId, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens) {
        this.uri = uri;
        this.organizationId = organizationId;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
    }

    public OpenAiServiceSettings(@Nullable String uri, @Nullable String organizationId, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens) {
        this(OpenAiServiceSettings.createOptionalUri(uri), organizationId, similarity, dimensions, maxInputTokens);
    }

    private static URI createOptionalUri(String url) {
        if (url == null) {
            return null;
        }
        return ServiceUtils.createUri(url);
    }

    public OpenAiServiceSettings(StreamInput in) throws IOException {
        this.uri = OpenAiServiceSettings.createOptionalUri(in.readOptionalString());
        this.organizationId = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.INFERENCE_SERVICE_EMBEDDING_SIZE_ADDED)) {
            this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
            this.dimensions = in.readOptionalVInt();
            this.maxInputTokens = in.readOptionalVInt();
        } else {
            this.similarity = null;
            this.dimensions = null;
            this.maxInputTokens = null;
        }
    }

    public URI uri() {
        return this.uri;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.organizationId != null) {
            builder.field(ORGANIZATION, this.organizationId);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        builder.endObject();
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_OPENAI_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        out.writeOptionalString(this.organizationId);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.INFERENCE_SERVICE_EMBEDDING_SIZE_ADDED)) {
            out.writeOptionalEnum((Enum)this.similarity);
            out.writeOptionalVInt(this.dimensions);
            out.writeOptionalVInt(this.maxInputTokens);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiServiceSettings that = (OpenAiServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals((Object)this.similarity, (Object)that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.organizationId, this.similarity, this.dimensions, this.maxInputTokens});
    }
}

