/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.huggingface;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class HuggingFaceElserResponseEntity {
    public static SparseEmbeddingResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            boolean[] truncationResults = request.getTruncationInfo();
            List parsedEmbeddings = XContentParserUtils.parseList((XContentParser)jsonParser, (parser, index) -> HuggingFaceElserResponseEntity.parseExpansionResult(truncationResults, parser, index));
            if (parsedEmbeddings.isEmpty()) {
                SparseEmbeddingResults sparseEmbeddingResults = new SparseEmbeddingResults(Collections.emptyList());
                return sparseEmbeddingResults;
            }
            SparseEmbeddingResults sparseEmbeddingResults = new SparseEmbeddingResults(parsedEmbeddings);
            return sparseEmbeddingResults;
        }
    }

    private static SparseEmbeddingResults.Embedding parseExpansionResult(boolean[] truncationResults, XContentParser parser, int index) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList<SparseEmbeddingResults.WeightedToken> weightedTokens = new ArrayList<SparseEmbeddingResults.WeightedToken>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            XContentParser.Token floatToken = parser.nextToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)floatToken, (XContentParser)parser);
            weightedTokens.add(new SparseEmbeddingResults.WeightedToken(parser.currentName(), parser.floatValue()));
        }
        boolean isTruncated = truncationResults != null && index < truncationResults.length && truncationResults[index];
        return new SparseEmbeddingResults.Embedding(weightedTokens, isTruncated);
    }

    private HuggingFaceElserResponseEntity() {
    }
}

