/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.openai;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.retry.RetryingHttpSender;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.openai.OpenAiResponseHandler;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.openai.OpenAiEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public class OpenAiClient {
    private static final Logger logger = LogManager.getLogger(OpenAiClient.class);
    private static final ResponseHandler EMBEDDINGS_HANDLER = OpenAiClient.createEmbeddingsHandler();
    private final RetryingHttpSender sender;

    public OpenAiClient(Sender sender, ServiceComponents serviceComponents) {
        this.sender = new RetryingHttpSender(sender, serviceComponents.throttlerManager(), logger, new RetrySettings(serviceComponents.settings()), serviceComponents.threadPool());
    }

    public void send(OpenAiEmbeddingsRequest request, ActionListener<InferenceServiceResults> listener) throws IOException {
        this.sender.send(request, EMBEDDINGS_HANDLER, listener);
    }

    private static ResponseHandler createEmbeddingsHandler() {
        return new OpenAiResponseHandler("openai text embedding", OpenAiEmbeddingsResponseEntity::fromResponse);
    }
}

