/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpClient;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.sender.HttpTask;

class RequestTask
extends HttpTask {
    private static final Logger logger = LogManager.getLogger(RequestTask.class);
    private static final Scheduler.Cancellable NOOP_TIMEOUT_HANDLER = RequestTask.createDefaultHandler();
    private final HttpUriRequest request;
    private final ActionListener<HttpResult> listener;
    private final Scheduler.Cancellable timeoutHandler;
    private final AtomicBoolean notified = new AtomicBoolean();
    private final TimeValue timeout;
    private final Runnable command;

    RequestTask(HttpUriRequest request, HttpClient httpClient, HttpClientContext context, @Nullable TimeValue timeout, ThreadPool threadPool, ActionListener<HttpResult> listener) {
        this.request = Objects.requireNonNull(request);
        this.listener = Objects.requireNonNull(listener);
        this.timeout = timeout;
        this.timeoutHandler = this.startTimer(threadPool, timeout);
        this.command = threadPool.getThreadContext().preserveContext((Runnable)new Command(Objects.requireNonNull(httpClient), this.request, Objects.requireNonNull(context), (ActionListener<HttpResult>)ActionListener.wrap(this::onSuccess, this::onFailure)));
    }

    private Scheduler.Cancellable startTimer(ThreadPool threadPool, TimeValue timeout) {
        Objects.requireNonNull(threadPool);
        if (timeout == null) {
            return NOOP_TIMEOUT_HANDLER;
        }
        return threadPool.schedule(this::onTimeout, timeout, (Executor)threadPool.executor("inference_utility"));
    }

    private void onTimeout() {
        assert (this.timeout != null) : "timeout must be defined to use a timeout handler";
        logger.debug(() -> Strings.format((String)"Request [%s] timed out after [%s] while waiting to be executed", (Object[])new Object[]{this.request.getRequestLine(), this.timeout}));
        this.notifyOfResult(() -> this.listener.onFailure((Exception)new ElasticsearchTimeoutException(Strings.format((String)"Request timed out waiting to be executed after [%s]", (Object[])new Object[]{this.timeout}), new Object[0])));
    }

    private void notifyOfResult(Runnable runnable) {
        if (this.notified.compareAndSet(false, true)) {
            runnable.run();
            return;
        }
        logger.debug(() -> Strings.format((String)"Attempting to notify of result after already doing so for request [%s]", (Object[])new Object[]{this.request.getRequestLine()}));
    }

    public void onFailure(Exception e) {
        this.timeoutHandler.cancel();
        this.notifyOfResult(() -> this.listener.onFailure(e));
    }

    protected void doRun() {
        try {
            this.command.run();
        }
        catch (Exception e) {
            String message = Strings.format((String)"Failed while executing request [%s]", (Object[])new Object[]{this.request.getRequestLine()});
            logger.warn(message, (Throwable)e);
            this.onFailure((Exception)((Object)new ElasticsearchException(message, (Throwable)e, new Object[0])));
        }
    }

    private void onSuccess(HttpResult result) {
        this.timeoutHandler.cancel();
        this.notifyOfResult(() -> this.listener.onResponse((Object)result));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }

    private static Scheduler.Cancellable createDefaultHandler() {
        return new Scheduler.Cancellable(){

            public boolean cancel() {
                return true;
            }

            public boolean isCancelled() {
                return true;
            }
        };
    }

    private record Command(HttpClient httpClient, HttpUriRequest requestToSend, HttpClientContext context, ActionListener<HttpResult> resultListener) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.httpClient.send(this.requestToSend, this.context, this.resultListener);
            }
            catch (Exception e) {
                logger.warn(Strings.format((String)"Failed to send request [%s] via the http client", (Object[])new Object[]{this.requestToSend.getRequestLine()}), (Throwable)e);
                this.resultListener.onFailure((Exception)((Object)new ElasticsearchException(Strings.format((String)"Failed to send request [%s]", (Object[])new Object[]{this.requestToSend.getRequestLine()}), (Throwable)e, new Object[0])));
            }
        }
    }
}

