/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpClientManager;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestExecutorService;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;

public class HttpRequestSenderFactory {
    private final ThreadPool threadPool;
    private final HttpClientManager httpClientManager;
    private final ClusterService clusterService;
    private final Settings settings;

    public HttpRequestSenderFactory(ThreadPool threadPool, HttpClientManager httpClientManager, ClusterService clusterService, Settings settings) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.httpClientManager = Objects.requireNonNull(httpClientManager);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.settings = Objects.requireNonNull(settings);
    }

    public Sender createSender(String serviceName) {
        return new HttpRequestSender(serviceName, this.threadPool, this.httpClientManager, this.clusterService, this.settings);
    }

    public static final class HttpRequestSender
    implements Sender {
        private static final Logger logger = LogManager.getLogger(HttpRequestSender.class);
        private static final TimeValue START_COMPLETED_WAIT_TIME = TimeValue.timeValueSeconds((long)5L);
        public static final Setting<TimeValue> MAX_REQUEST_TIMEOUT = Setting.timeSetting((String)"xpack.inference.http.max_request_timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        private final ThreadPool threadPool;
        private final HttpClientManager manager;
        private final HttpRequestExecutorService service;
        private final AtomicBoolean started = new AtomicBoolean(false);
        private volatile TimeValue maxRequestTimeout;
        private final CountDownLatch startCompleted = new CountDownLatch(2);

        private HttpRequestSender(String serviceName, ThreadPool threadPool, HttpClientManager httpClientManager, ClusterService clusterService, Settings settings) {
            this.threadPool = Objects.requireNonNull(threadPool);
            this.manager = Objects.requireNonNull(httpClientManager);
            this.service = new HttpRequestExecutorService(serviceName, this.manager.getHttpClient(), threadPool, this.startCompleted);
            this.maxRequestTimeout = (TimeValue)MAX_REQUEST_TIMEOUT.get(settings);
            this.addSettingsUpdateConsumers(clusterService);
        }

        private void addSettingsUpdateConsumers(ClusterService clusterService) {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_REQUEST_TIMEOUT, this::setMaxRequestTimeout);
        }

        void setMaxRequestTimeout(TimeValue maxRequestTimeout) {
            logger.debug(() -> Strings.format((String)"Max request timeout updated to [%s] for service [%s]", (Object[])new Object[]{maxRequestTimeout, this.service}));
            this.maxRequestTimeout = maxRequestTimeout;
        }

        @Override
        public void start() {
            if (this.started.compareAndSet(false, true)) {
                this.manager.start();
                this.threadPool.executor("inference_utility").execute(this.service::start);
                this.startCompleted.countDown();
            }
        }

        @Override
        public void close() throws IOException {
            this.manager.close();
            this.service.shutdown();
        }

        @Override
        public void send(HttpRequestBase request, @Nullable TimeValue timeout, ActionListener<HttpResult> listener) {
            assert (this.started.get()) : "call start() before sending a request";
            this.waitForStartToComplete();
            this.service.send(request, timeout, listener);
        }

        private void waitForStartToComplete() {
            try {
                if (!this.startCompleted.await(START_COMPLETED_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Http sender startup did not complete in time");
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Http sender interrupted while waiting for startup to complete");
            }
        }

        @Override
        public void send(HttpRequestBase request, ActionListener<HttpResult> listener) {
            assert (this.started.get()) : "call start() before sending a request";
            this.waitForStartToComplete();
            this.service.send(request, this.maxRequestTimeout, listener);
        }

        public static List<Setting<?>> getSettings() {
            return List.of(MAX_REQUEST_TIMEOUT);
        }
    }
}

