/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.Retrier;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.retry.Retryable;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class RetryingHttpSender
implements Retrier {
    private final Sender sender;
    private final ThrottlerManager throttlerManager;
    private final Logger logger;
    private final RetrySettings retrySettings;
    private final ThreadPool threadPool;
    private final Executor executor;

    public RetryingHttpSender(Sender sender, ThrottlerManager throttlerManager, Logger logger, RetrySettings retrySettings, ThreadPool threadPool) {
        this(sender, throttlerManager, logger, retrySettings, threadPool, threadPool.executor("inference_utility"));
    }

    RetryingHttpSender(Sender sender, ThrottlerManager throttlerManager, Logger logger, RetrySettings retrySettings, ThreadPool threadPool, Executor executor) {
        this.sender = Objects.requireNonNull(sender);
        this.throttlerManager = Objects.requireNonNull(throttlerManager);
        this.logger = Objects.requireNonNull(logger);
        this.retrySettings = Objects.requireNonNull(retrySettings);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public void send(Request request, ResponseHandler responseHandler, ActionListener<InferenceServiceResults> listener) {
        InternalRetrier retrier = new InternalRetrier(request, responseHandler, listener);
        retrier.run();
    }

    private void logException(HttpRequestBase request, String requestType, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttlerManager.warn(this.logger, Strings.format((String)"Failed while sending request [%s] of type [%s]", (Object[])new Object[]{request.getRequestLine(), requestType}), causeException);
    }

    private void logException(HttpRequestBase request, HttpResult result, String requestType, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttlerManager.warn(this.logger, Strings.format((String)"Failed to process the response for request [%s] of type [%s] with status [%s] [%s]", (Object[])new Object[]{request.getRequestLine(), requestType, result.response().getStatusLine().getStatusCode(), result.response().getStatusLine().getReasonPhrase()}), causeException);
    }

    private class InternalRetrier
    extends RetryableAction<InferenceServiceResults> {
        private Request request;
        private final ResponseHandler responseHandler;

        InternalRetrier(Request request, ResponseHandler responseHandler, ActionListener<InferenceServiceResults> listener) {
            super(RetryingHttpSender.this.logger, RetryingHttpSender.this.threadPool, RetryingHttpSender.this.retrySettings.getSettings().initialDelay(), RetryingHttpSender.this.retrySettings.getSettings().maxDelayBound(), RetryingHttpSender.this.retrySettings.getSettings().timeoutValue(), listener, RetryingHttpSender.this.executor);
            this.request = request;
            this.responseHandler = responseHandler;
        }

        public void tryAction(ActionListener<InferenceServiceResults> listener) {
            HttpRequestBase httpRequest = this.request.createRequest();
            ActionListener responseListener = ActionListener.wrap(result -> {
                try {
                    this.responseHandler.validateResponse(RetryingHttpSender.this.throttlerManager, RetryingHttpSender.this.logger, httpRequest, (HttpResult)result);
                    InferenceServiceResults inferenceResults = this.responseHandler.parseResult(this.request, (HttpResult)result);
                    listener.onResponse((Object)inferenceResults);
                }
                catch (Exception e) {
                    RetryingHttpSender.this.logException(httpRequest, (HttpResult)result, this.responseHandler.getRequestType(), e);
                    listener.onFailure(e);
                }
            }, e -> {
                RetryingHttpSender.this.logException(httpRequest, this.responseHandler.getRequestType(), (Exception)e);
                listener.onFailure(this.transformIfRetryable((Exception)e));
            });
            RetryingHttpSender.this.sender.send(httpRequest, (ActionListener<HttpResult>)responseListener);
        }

        public boolean shouldRetry(Exception e) {
            if (e instanceof Retryable) {
                Retryable retry = (Retryable)((Object)e);
                this.request = retry.rebuildRequest(this.request);
                return retry.shouldRetry();
            }
            return false;
        }

        private Exception transformIfRetryable(Exception e) {
            Object exceptionToReturn = e;
            if (e instanceof UnknownHostException) {
                return new ElasticsearchStatusException(Strings.format((String)"Invalid host [%s], please check that the URL is correct.", (Object[])new Object[]{this.request.getURI()}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
            }
            if (e instanceof IOException) {
                exceptionToReturn = new RetryException(true, e);
            }
            return exceptionToReturn;
        }
    }
}

