/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpClient;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.IdleConnectionEvictor;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpClientManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(HttpClientManager.class);
    public static final Setting<Integer> MAX_CONNECTIONS = Setting.intSetting((String)"xpack.inference.http.max_connections", (int)20, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME = TimeValue.timeValueMinutes((long)1L);
    public static final Setting<TimeValue> CONNECTION_EVICTION_THREAD_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.inference.http.connection_eviction_interval", (TimeValue)DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING = DEFAULT_CONNECTION_EVICTION_THREAD_INTERVAL_TIME;
    public static final Setting<TimeValue> CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING = Setting.timeSetting((String)"xpack.inference.http.connection_eviction_max_idle_time", (TimeValue)DEFAULT_CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ThreadPool threadPool;
    private final PoolingNHttpClientConnectionManager connectionManager;
    private EvictorSettings evictorSettings;
    private IdleConnectionEvictor connectionEvictor;
    private final HttpClient httpClient;

    public static HttpClientManager create(Settings settings, ThreadPool threadPool, ClusterService clusterService, ThrottlerManager throttlerManager) {
        PoolingNHttpClientConnectionManager connectionManager = HttpClientManager.createConnectionManager();
        return new HttpClientManager(settings, connectionManager, threadPool, clusterService, throttlerManager);
    }

    HttpClientManager(Settings settings, PoolingNHttpClientConnectionManager connectionManager, ThreadPool threadPool, ClusterService clusterService, ThrottlerManager throttlerManager) {
        this.threadPool = threadPool;
        this.connectionManager = connectionManager;
        this.setMaxConnections((Integer)MAX_CONNECTIONS.get(settings));
        this.httpClient = HttpClient.create(new HttpSettings(settings, clusterService), threadPool, connectionManager, throttlerManager);
        this.evictorSettings = new EvictorSettings(settings);
        this.connectionEvictor = this.createConnectionEvictor();
        this.addSettingsUpdateConsumers(clusterService);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager() {
        DefaultConnectingIOReactor ioReactor;
        try {
            IOReactorConfig.Builder configBuilder = IOReactorConfig.custom().setSoKeepAlive(true);
            ioReactor = new DefaultConnectingIOReactor(configBuilder.build());
        }
        catch (IOReactorException e) {
            String message = "Failed to initialize the inference http client manager";
            logger.error(message, (Throwable)e);
            throw new ElasticsearchException(message, (Throwable)e, new Object[0]);
        }
        return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS, this::setMaxConnections);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_EVICTION_THREAD_INTERVAL_SETTING, this::setEvictionInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING, this::setEvictionMaxIdle);
    }

    private IdleConnectionEvictor createConnectionEvictor() {
        return new IdleConnectionEvictor(this.threadPool, (NHttpClientConnectionManager)this.connectionManager, this.evictorSettings.evictionInterval, this.evictorSettings.evictionMaxIdle);
    }

    public static List<Setting<?>> getSettings() {
        return List.of(MAX_CONNECTIONS, CONNECTION_EVICTION_THREAD_INTERVAL_SETTING, CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING);
    }

    public void start() {
        this.httpClient.start();
        this.connectionEvictor.start();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
        this.connectionEvictor.close();
    }

    private void setMaxConnections(int maxConnections) {
        this.connectionManager.setMaxTotal(maxConnections);
        this.connectionManager.setDefaultMaxPerRoute(maxConnections);
    }

    boolean isEvictionThreadRunning() {
        return this.connectionEvictor.isRunning();
    }

    void setEvictionInterval(TimeValue evictionInterval) {
        logger.debug(() -> Strings.format((String)"Eviction thread's interval time updated to [%s]", (Object[])new Object[]{evictionInterval}));
        this.evictorSettings = new EvictorSettings(evictionInterval, this.evictorSettings.evictionMaxIdle);
        this.connectionEvictor.close();
        this.connectionEvictor = this.createConnectionEvictor();
        this.connectionEvictor.start();
    }

    void setEvictionMaxIdle(TimeValue evictionMaxIdle) {
        logger.debug(() -> Strings.format((String)"Eviction thread's max idle time updated to [%s]", (Object[])new Object[]{evictionMaxIdle}));
        this.evictorSettings = new EvictorSettings(this.evictorSettings.evictionInterval, evictionMaxIdle);
        this.connectionEvictor.setMaxIdleTime(evictionMaxIdle);
    }

    private static class EvictorSettings {
        private final TimeValue evictionInterval;
        private final TimeValue evictionMaxIdle;

        EvictorSettings(Settings settings) {
            this.evictionInterval = (TimeValue)CONNECTION_EVICTION_THREAD_INTERVAL_SETTING.get(settings);
            this.evictionMaxIdle = (TimeValue)CONNECTION_EVICTION_MAX_IDLE_TIME_SETTING.get(settings);
        }

        EvictorSettings(TimeValue evictionInterval, TimeValue evictionMaxIdle) {
            this.evictionInterval = evictionInterval;
            this.evictionMaxIdle = evictionMaxIdle;
        }
    }
}

