/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.openai;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.openai.OpenAiAccount;
import org.elasticsearch.xpack.inference.external.openai.OpenAiClient;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsModel;

public class OpenAiEmbeddingsAction
implements ExecutableAction {
    private final OpenAiAccount account;
    private final OpenAiClient client;
    private final OpenAiEmbeddingsModel model;
    private final String errorMessage;
    private final Truncator truncator;

    public OpenAiEmbeddingsAction(Sender sender, OpenAiEmbeddingsModel model, ServiceComponents serviceComponents) {
        this.model = Objects.requireNonNull(model);
        this.account = new OpenAiAccount(this.model.getServiceSettings().uri(), this.model.getServiceSettings().organizationId(), this.model.getSecretSettings().apiKey());
        this.client = new OpenAiClient(Objects.requireNonNull(sender), Objects.requireNonNull(serviceComponents));
        this.errorMessage = OpenAiEmbeddingsAction.getErrorMessage(this.model.getServiceSettings().uri());
        this.truncator = Objects.requireNonNull(serviceComponents.truncator());
    }

    private static String getErrorMessage(@Nullable URI uri) {
        if (uri != null) {
            return Strings.format((String)"Failed to send OpenAI embeddings request to [%s]", (Object[])new Object[]{uri.toString()});
        }
        return "Failed to send OpenAI embeddings request";
    }

    @Override
    public void execute(List<String> input, ActionListener<InferenceServiceResults> listener) {
        try {
            Truncator.TruncationResult truncatedInput = Truncator.truncate(input, this.model.getServiceSettings().maxInputTokens());
            OpenAiEmbeddingsRequest request = new OpenAiEmbeddingsRequest(this.truncator, this.account, truncatedInput, this.model.getTaskSettings());
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.errorMessage, listener);
            this.client.send(request, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.errorMessage));
        }
    }
}

