/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;

public class DoubleGaugeAdapter
extends AbstractInstrument<ObservableDoubleGauge>
implements DoubleGauge {
    private final Supplier<DoubleWithAttributes> observer;
    private final ReleasableLock closedLock = new ReleasableLock((Lock)new ReentrantLock());
    private boolean closed = false;

    public DoubleGaugeAdapter(Meter meter, String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        super(meter, name, description, unit);
        this.observer = observer;
    }

    @Override
    protected ObservableDoubleGauge buildInstrument(Meter meter) {
        return Objects.requireNonNull(meter).gaugeBuilder(this.getName()).setDescription(this.getDescription()).setUnit(this.getUnit()).buildWithCallback(measurement -> {
            DoubleWithAttributes observation;
            try {
                observation = this.observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                return;
            }
            measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
        });
    }

    public void close() throws Exception {
        try (ReleasableLock lock = this.closedLock.acquire();){
            if (!this.closed) {
                ((ObservableDoubleGauge)this.getInstrument()).close();
            }
            this.closed = true;
        }
    }
}

