/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;

public class PutAutoscalingPolicyAction
extends ActionType<AcknowledgedResponse> {
    public static final PutAutoscalingPolicyAction INSTANCE = new PutAutoscalingPolicyAction();
    public static final String NAME = "cluster:admin/autoscaling/put_autoscaling_policy";

    private PutAutoscalingPolicyAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_autocaling_policy_request", false, (c, name) -> {
            List roles = (List)c[0];
            List deciders = (List)c[1];
            return new Request((String)name, roles != null ? (SortedSet)roles.stream().collect(Sets.toUnmodifiableSortedSet()) : null, (SortedMap<String, Settings>)(deciders != null ? new TreeMap<String, Settings>(deciders.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))) : null));
        });
        private final String name;
        private final SortedSet<String> roles;
        private final SortedMap<String, Settings> deciders;

        public static Request parse(XContentParser parser, String name) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public Request(String name, SortedSet<String> roles, SortedMap<String, Settings> deciders) {
            this.name = name;
            this.roles = roles;
            this.deciders = deciders;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.roles = in.readBoolean() ? (SortedSet)in.readCollectionAsSet(StreamInput::readString).stream().collect(Sets.toUnmodifiableSortedSet()) : null;
            if (in.readBoolean()) {
                int deciderCount = in.readInt();
                TreeMap<String, Settings> decidersMap = new TreeMap<String, Settings>();
                for (int i = 0; i < deciderCount; ++i) {
                    decidersMap.put(in.readString(), Settings.readSettingsFromStream((StreamInput)in));
                }
                this.deciders = Collections.unmodifiableSortedMap(decidersMap);
            } else {
                this.deciders = null;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            if (this.roles != null) {
                out.writeBoolean(true);
                out.writeStringCollection(this.roles);
            } else {
                out.writeBoolean(false);
            }
            if (this.deciders != null) {
                out.writeBoolean(true);
                out.writeInt(this.deciders.size());
                for (Map.Entry<String, Settings> entry : this.deciders.entrySet()) {
                    out.writeString(entry.getKey());
                    entry.getValue().writeTo(out);
                }
            } else {
                out.writeBoolean(false);
            }
        }

        public String name() {
            return this.name;
        }

        public SortedSet<String> roles() {
            return this.roles;
        }

        public SortedMap<String, Settings> deciders() {
            return this.deciders;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException exception = null;
            if (this.roles != null) {
                List errors = this.roles.stream().filter(Predicate.not(DiscoveryNodeRole.roleNames()::contains)).collect(Collectors.toList());
                if (!errors.isEmpty()) {
                    exception = new ActionRequestValidationException();
                    exception.addValidationErrors(errors);
                }
            }
            if (!Strings.validFileName((String)this.name)) {
                exception = ValidateActions.addValidationError((String)("name must not contain the following characters " + Strings.INVALID_FILENAME_CHARS), exception);
            }
            return exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.name.equals(request.name) && Objects.equals(this.roles, request.roles) && Objects.equals(this.deciders, request.deciders);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.roles, this.deciders);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), AutoscalingPolicy.ROLES_FIELD);
            PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
                p.nextToken();
                return new AbstractMap.SimpleEntry<String, Settings>(n, Settings.fromXContent((XContentParser)p));
            }, AutoscalingPolicy.DECIDERS_FIELD);
        }
    }
}

