/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.ErrorStep;
import org.elasticsearch.xpack.core.ilm.PhaseCompleteStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TerminalPolicyStep;
import org.elasticsearch.xpack.ilm.ExecuteStepsUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleClusterStateUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;
import org.elasticsearch.xpack.ilm.MoveToErrorStepUpdateTask;
import org.elasticsearch.xpack.ilm.MoveToNextStepUpdateTask;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;
import org.elasticsearch.xpack.ilm.SetStepInfoUpdateTask;
import org.elasticsearch.xpack.ilm.history.ILMHistoryItem;
import org.elasticsearch.xpack.ilm.history.ILMHistoryStore;

class IndexLifecycleRunner {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final PolicyStepsRegistry stepRegistry;
    private final ILMHistoryStore ilmHistoryStore;
    private final LongSupplier nowSupplier;
    private final MasterServiceTaskQueue<IndexLifecycleClusterStateUpdateTask> masterServiceTaskQueue;
    private static final ClusterStateTaskExecutor<IndexLifecycleClusterStateUpdateTask> ILM_TASK_EXECUTOR = new ClusterStateTaskExecutor<IndexLifecycleClusterStateUpdateTask>(){

        @SuppressForbidden(reason="consuming published cluster state for legacy reasons")
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<IndexLifecycleClusterStateUpdateTask> batchExecutionContext) {
            ClusterState state = batchExecutionContext.initialState();
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                try {
                    IndexLifecycleClusterStateUpdateTask task = (IndexLifecycleClusterStateUpdateTask)taskContext.getTask();
                    try (Releasable ignored = taskContext.captureResponseHeaders();){
                        state = task.execute(state);
                    }
                    taskContext.success(publishedState -> task.clusterStateProcessed(batchExecutionContext.initialState(), (ClusterState)publishedState));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            return state;
        }
    };
    private final Set<IndexLifecycleClusterStateUpdateTask> executingTasks = Collections.synchronizedSet(new HashSet());
    private final Set<Tuple<Index, Step.StepKey>> busyIndices = Collections.synchronizedSet(new HashSet());

    IndexLifecycleRunner(PolicyStepsRegistry stepRegistry, ILMHistoryStore ilmHistoryStore, ClusterService clusterService, ThreadPool threadPool, LongSupplier nowSupplier) {
        this.stepRegistry = stepRegistry;
        this.ilmHistoryStore = ilmHistoryStore;
        this.clusterService = clusterService;
        this.nowSupplier = nowSupplier;
        this.threadPool = threadPool;
        this.masterServiceTaskQueue = clusterService.createTaskQueue("ilm-runner", Priority.NORMAL, ILM_TASK_EXECUTOR);
    }

    static Step getCurrentStep(PolicyStepsRegistry stepRegistry, String policy, IndexMetadata indexMetadata) {
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        return IndexLifecycleRunner.getCurrentStep(stepRegistry, policy, indexMetadata, lifecycleState);
    }

    static Step getCurrentStep(PolicyStepsRegistry stepRegistry, String policy, IndexMetadata indexMetadata, LifecycleExecutionState lifecycleState) {
        Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        logger.trace("[{}] retrieved current step key: {}", (Object)indexMetadata.getIndex().getName(), (Object)currentStepKey);
        if (currentStepKey == null) {
            return stepRegistry.getFirstStep(policy);
        }
        return stepRegistry.getStep(indexMetadata, currentStepKey);
    }

    @Nullable
    private static Long calculateOriginationMillis(IndexMetadata indexMetadata) {
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        Long originationDate = indexMetadata.getSettings().getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L));
        if (lifecycleState.lifecycleDate() == null && originationDate == -1L) {
            return null;
        }
        return originationDate == -1L ? lifecycleState.lifecycleDate() : originationDate;
    }

    boolean isReadyToTransitionToThisPhase(String policy, IndexMetadata indexMetadata, String phase) {
        Long lifecycleDate = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        if (lifecycleDate == null) {
            logger.trace("[{}] no index creation or origination date has been set yet", (Object)indexMetadata.getIndex().getName());
            return true;
        }
        TimeValue after = this.stepRegistry.getIndexAgeForPhase(policy, phase);
        long now = this.nowSupplier.getAsLong();
        if (logger.isTraceEnabled()) {
            long ageMillis = now - lifecycleDate;
            TimeValue age = ageMillis >= 0L ? new TimeValue(ageMillis) : (ageMillis == Long.MIN_VALUE ? new TimeValue(Long.MAX_VALUE) : new TimeValue(-ageMillis));
            logger.trace("[{}] checking for index age to be at least [{}] before performing actions in the \"{}\" phase. Now: {}, lifecycle date: {}, age: [{}{}/{}s]", (Object)indexMetadata.getIndex().getName(), (Object)after, (Object)phase, (Object)new TimeValue(now).seconds(), (Object)new TimeValue(lifecycleDate.longValue()).seconds(), (Object)(ageMillis < 0L ? "-" : ""), (Object)age, (Object)age.seconds());
        }
        return now >= lifecycleDate + after.getMillis();
    }

    void runPeriodicStep(final String policy, Metadata metadata, final IndexMetadata indexMetadata) {
        Step currentStep;
        final String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata, lifecycleState);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            if (!this.stepRegistry.policyExists(policy)) {
                this.markPolicyDoesNotExist(policy, indexMetadata.getIndex(), lifecycleState);
                return;
            }
            Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.error("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        if (currentStep instanceof TerminalPolicyStep) {
            logger.debug("policy [{}] for index [{}] complete, skipping execution", (Object)policy, (Object)index);
            return;
        }
        if (currentStep instanceof ErrorStep) {
            this.onErrorMaybeRetryFailedStep(policy, currentStep.getKey(), indexMetadata);
            return;
        }
        logger.trace("[{}] maybe running periodic step ({}) with current step {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (currentStep instanceof PhaseCompleteStep) {
            if (currentStep.getNextStepKey() == null) {
                logger.debug("[{}] stopping in the current phase ({}) as there are no more steps in the policy", (Object)index, (Object)currentStep.getKey().phase());
                return;
            }
            if (this.isReadyToTransitionToThisPhase(policy, indexMetadata, currentStep.getNextStepKey().phase())) {
                this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
            }
        } else if (currentStep instanceof AsyncWaitStep) {
            logger.debug("[{}] running periodic policy with current-step [{}]", (Object)index, (Object)currentStep.getKey());
            ((AsyncWaitStep)currentStep).evaluateCondition(metadata, indexMetadata.getIndex(), new AsyncWaitStep.Listener(){

                public void onResponse(boolean conditionMet, ToXContentObject stepInfo) {
                    logger.trace("cs-change-async-wait-callback, [{}] current-step: {}", (Object)index, (Object)currentStep.getKey());
                    if (conditionMet) {
                        IndexLifecycleRunner.this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
                    } else if (stepInfo != null) {
                        IndexLifecycleRunner.this.setStepInfo(indexMetadata.getIndex(), policy, currentStep.getKey(), stepInfo);
                    }
                }

                public void onFailure(Exception e) {
                    IndexLifecycleRunner.this.moveToErrorStep(indexMetadata.getIndex(), policy, currentStep.getKey(), e);
                }
            }, TimeValue.MAX_VALUE);
        } else {
            logger.trace("[{}] ignoring non periodic step execution from step transition [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    void onErrorMaybeRetryFailedStep(String policy, Step.StepKey currentStep, IndexMetadata indexMetadata) {
        String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        Step failedStep = this.stepRegistry.getStep(indexMetadata, new Step.StepKey(lifecycleState.phase(), lifecycleState.action(), lifecycleState.failedStep()));
        if (failedStep == null) {
            logger.warn("failed step [{}] for index [{}] is not part of policy [{}] anymore, or it is invalid. skipping execution", (Object)lifecycleState.failedStep(), (Object)index, (Object)policy);
            return;
        }
        if (lifecycleState.isAutoRetryableError() != null && lifecycleState.isAutoRetryableError().booleanValue()) {
            int currentRetryAttempt = lifecycleState.failedStepRetryCount() == null ? 1 : 1 + lifecycleState.failedStepRetryCount();
            logger.info("policy [{}] for index [{}] on an error step due to a transient error, moving back to the failed step [{}] for execution. retry attempt [{}]", (Object)policy, (Object)index, (Object)lifecycleState.failedStep(), (Object)currentRetryAttempt);
            this.submitUnlessAlreadyQueued(String.format(Locale.ROOT, "ilm-retry-failed-step {policy [%s], index [%s], failedStep [%s]}", policy, index, failedStep.getKey()), new MoveToRetryFailedStepUpdateTask(indexMetadata.getIndex(), policy, currentStep, failedStep));
        } else {
            logger.debug("policy [{}] for index [{}] on an error step after a terminal error, skipping execution", (Object)policy, (Object)index);
        }
    }

    void maybeRunAsyncAction(ClusterState currentState, final IndexMetadata indexMetadata, final String policy, Step.StepKey expectedStepKey) {
        Step currentStep;
        final String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata, lifecycleState);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.warn("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        logger.trace("[{}] maybe running async action step ({}) with current step {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (!currentStep.getKey().equals((Object)expectedStepKey)) {
            throw new IllegalStateException("expected index [" + indexMetadata.getIndex().getName() + "] with policy [" + policy + "] to have current step consistent with provided step key (" + expectedStepKey + ") but it was " + currentStep.getKey());
        }
        if (currentStep instanceof AsyncActionStep) {
            logger.debug("[{}] running policy with async action step [{}]", (Object)index, (Object)currentStep.getKey());
            ((AsyncActionStep)currentStep).performAction(indexMetadata, currentState, new ClusterStateObserver(this.clusterService, null, logger, this.threadPool.getThreadContext()), (ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    logger.trace("cs-change-async-action-callback, [{}], current-step: {}", (Object)index, (Object)currentStep.getKey());
                    if (((AsyncActionStep)currentStep).indexSurvives()) {
                        IndexLifecycleRunner.this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
                    } else {
                        IndexLifecycleRunner.this.registerDeleteOperation(indexMetadata);
                    }
                }

                public void onFailure(Exception e) {
                    IndexLifecycleRunner.this.moveToErrorStep(indexMetadata.getIndex(), policy, currentStep.getKey(), e);
                }
            });
        } else {
            logger.trace("[{}] ignoring non async action step execution from step transition [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    void runPolicyAfterStateChange(String policy, IndexMetadata indexMetadata) {
        Step currentStep;
        String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        if (this.busyIndices.contains(Tuple.tuple((Object)indexMetadata.getIndex(), (Object)currentStepKey))) {
            return;
        }
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata, lifecycleState);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            if (!this.stepRegistry.policyExists(policy)) {
                this.markPolicyDoesNotExist(policy, indexMetadata.getIndex(), lifecycleState);
                return;
            }
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.error("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        if (currentStep instanceof TerminalPolicyStep) {
            logger.debug("policy [{}] for index [{}] complete, skipping execution", (Object)policy, (Object)index);
            return;
        }
        if (currentStep instanceof ErrorStep) {
            logger.debug("policy [{}] for index [{}] on an error step, skipping execution", (Object)policy, (Object)index);
            return;
        }
        logger.trace("[{}] maybe running step ({}) after state change: {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (currentStep instanceof PhaseCompleteStep) {
            if (currentStep.getNextStepKey() == null) {
                logger.debug("[{}] stopping in the current phase ({}) as there are no more steps in the policy", (Object)index, (Object)currentStep.getKey().phase());
                return;
            }
            if (this.isReadyToTransitionToThisPhase(policy, indexMetadata, currentStep.getNextStepKey().phase())) {
                this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
            }
        } else if (currentStep instanceof ClusterStateActionStep || currentStep instanceof ClusterStateWaitStep) {
            logger.debug("[{}] running policy with current-step [{}]", (Object)indexMetadata.getIndex().getName(), (Object)currentStep.getKey());
            this.submitUnlessAlreadyQueued(String.format(Locale.ROOT, "ilm-execute-cluster-state-steps [%s]", currentStep), new ExecuteStepsUpdateTask(policy, indexMetadata.getIndex(), currentStep, this.stepRegistry, this, this.nowSupplier));
        } else {
            logger.trace("[{}] ignoring step execution from cluster state change event [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    private void moveToStep(Index index, String policy, Step.StepKey currentStepKey, Step.StepKey newStepKey) {
        logger.debug("[{}] moving to step [{}] {} -> {}", (Object)index.getName(), (Object)policy, (Object)currentStepKey, (Object)newStepKey);
        this.submitUnlessAlreadyQueued(String.format(Locale.ROOT, "ilm-move-to-step {policy [%s], index [%s], currentStep [%s], nextStep [%s]}", policy, index.getName(), currentStepKey, newStepKey), new MoveToNextStepUpdateTask(index, policy, currentStepKey, newStepKey, this.nowSupplier, this.stepRegistry, clusterState -> {
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            this.registerSuccessfulOperation(indexMetadata);
            if (newStepKey != null && newStepKey != TerminalPolicyStep.KEY && indexMetadata != null) {
                this.maybeRunAsyncAction((ClusterState)clusterState, indexMetadata, policy, newStepKey);
            }
        }));
    }

    private void moveToErrorStep(Index index, String policy, Step.StepKey currentStepKey, Exception e) {
        logger.error(() -> Strings.format((String)"policy [%s] for index [%s] failed on step [%s]. Moving to ERROR step", (Object[])new Object[]{policy, index.getName(), currentStepKey}), (Throwable)e);
        this.submitUnlessAlreadyQueued(String.format(Locale.ROOT, "ilm-move-to-error-step {policy [%s], index [%s], currentStep [%s]}", policy, index.getName(), currentStepKey), new MoveToErrorStepUpdateTask(index, policy, currentStepKey, e, this.nowSupplier, this.stepRegistry::getStep, clusterState -> {
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            this.registerFailedOperation(indexMetadata, e);
        }));
    }

    private void setStepInfo(Index index, String policy, @Nullable Step.StepKey currentStepKey, ToXContentObject stepInfo) {
        this.submitUnlessAlreadyQueued(String.format(Locale.ROOT, "ilm-set-step-info {policy [%s], index [%s], currentStep [%s]}", policy, index.getName(), currentStepKey), new SetStepInfoUpdateTask(index, policy, currentStepKey, stepInfo));
    }

    private void markPolicyDoesNotExist(String policyName, Index index, LifecycleExecutionState executionState) {
        this.markPolicyRetrievalError(policyName, index, executionState, new IllegalArgumentException("policy [" + policyName + "] does not exist"));
    }

    private void markPolicyRetrievalError(String policyName, Index index, LifecycleExecutionState executionState, Exception e) {
        logger.debug(() -> Strings.format((String)"unable to retrieve policy [%s] for index [%s], recording this in step_info for this index", (Object[])new Object[]{policyName, index.getName()}), (Throwable)e);
        this.setStepInfo(index, policyName, Step.getCurrentStepKey((LifecycleExecutionState)executionState), new SetStepInfoUpdateTask.ExceptionWrapper(e));
    }

    void registerSuccessfulOperation(IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            return;
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.success(indexMetadata.getIndex().getName(), indexMetadata.getLifecyclePolicyName(), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), indexMetadata.getLifecycleExecutionState()));
    }

    void registerDeleteOperation(IndexMetadata metadataBeforeDeletion) {
        if (metadataBeforeDeletion == null) {
            throw new IllegalStateException("cannot register deletion of an index that did not previously exist");
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(metadataBeforeDeletion);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.success(metadataBeforeDeletion.getIndex().getName(), metadataBeforeDeletion.getLifecyclePolicyName(), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), LifecycleExecutionState.builder((LifecycleExecutionState)metadataBeforeDeletion.getLifecycleExecutionState()).setStep("complete").build()));
    }

    void registerFailedOperation(IndexMetadata indexMetadata, Exception failure) {
        if (indexMetadata == null) {
            return;
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.failure(indexMetadata.getIndex().getName(), indexMetadata.getLifecyclePolicyName(), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), indexMetadata.getLifecycleExecutionState(), failure));
    }

    private void submitUnlessAlreadyQueued(String source, IndexLifecycleClusterStateUpdateTask task) {
        if (this.executingTasks.add(task)) {
            Tuple dedupKey = Tuple.tuple((Object)task.index, (Object)task.currentStepKey);
            this.busyIndices.add((Tuple<Index, Step.StepKey>)dedupKey);
            task.addListener((ActionListener<Void>)ActionListener.running(() -> {
                boolean removed = this.executingTasks.remove(task);
                this.busyIndices.remove(dedupKey);
                assert (removed) : "tried to unregister unknown task [" + task + "]";
            }));
            this.masterServiceTaskQueue.submitTask(source, (ClusterStateTaskListener)task, null);
        } else {
            logger.trace("skipped redundant execution of [{}]", (Object)source);
        }
    }

    private final class MoveToRetryFailedStepUpdateTask
    extends IndexLifecycleClusterStateUpdateTask {
        private final String policy;
        private final Step failedStep;

        MoveToRetryFailedStepUpdateTask(Index index, String policy, Step.StepKey currentStep, Step failedStep) {
            super(index, currentStep);
            this.policy = policy;
            this.failedStep = failedStep;
        }

        @Override
        protected ClusterState doExecute(ClusterState currentState) {
            return IndexLifecycleTransition.moveClusterStateToPreviouslyFailedStep(currentState, this.index.getName(), IndexLifecycleRunner.this.nowSupplier, IndexLifecycleRunner.this.stepRegistry, true);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MoveToRetryFailedStepUpdateTask)) {
                return false;
            }
            MoveToRetryFailedStepUpdateTask that = (MoveToRetryFailedStepUpdateTask)other;
            return this.index.equals((Object)that.index) && this.policy.equals(that.policy) && this.currentStepKey.equals((Object)that.currentStepKey) && this.failedStep.equals((Object)that.failedStep);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.index, this.policy, this.currentStepKey, this.failedStep);
        }

        @Override
        protected void handleFailure(Exception e) {
            logger.error(() -> Strings.format((String)"retry execution of step [%s] for index [%s] failed", (Object[])new Object[]{this.failedStep.getKey().name(), this.index}), (Throwable)e);
        }

        @Override
        protected void onClusterStateProcessed(ClusterState newState) {
            IndexMetadata newIndexMeta = newState.metadata().index(this.index);
            if (newIndexMeta == null) {
                return;
            }
            Step indexMetaCurrentStep = IndexLifecycleRunner.getCurrentStep(IndexLifecycleRunner.this.stepRegistry, this.policy, newIndexMeta);
            if (indexMetaCurrentStep == null) {
                return;
            }
            Step.StepKey stepKey = indexMetaCurrentStep.getKey();
            if (stepKey != null && stepKey != TerminalPolicyStep.KEY) {
                logger.trace("policy [{}] for index [{}] was moved back on the failed step for as part of an automatic retry. Attempting to execute the failed step [{}] if it's an async action", (Object)this.policy, (Object)this.index, (Object)stepKey);
                IndexLifecycleRunner.this.maybeRunAsyncAction(newState, newIndexMeta, this.policy, stepKey);
            }
        }
    }
}

