/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.Request;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.util.Maps;

public class S3RequestRetryStats {
    public static final String MESSAGE_FIELD = "message";
    private static final Logger logger = LogManager.getLogger(S3RequestRetryStats.class);
    private final AtomicLong requests = new AtomicLong();
    private final AtomicLong exceptions = new AtomicLong();
    private final AtomicLong throttles = new AtomicLong();
    private final AtomicLongArray exceptionsHistogram;
    private final AtomicLongArray throttlesHistogram;

    public S3RequestRetryStats(int maxRetries) {
        this.exceptionsHistogram = new AtomicLongArray(maxRetries + 1);
        this.throttlesHistogram = new AtomicLongArray(maxRetries + 1);
    }

    public void addRequest(Request<?> request) {
        if (request == null) {
            return;
        }
        TimingInfo info = request.getAWSRequestMetrics().getTimingInfo();
        long requests = S3RequestRetryStats.getCounter(info, AWSRequestMetrics.Field.RequestCount);
        long exceptions = S3RequestRetryStats.getCounter(info, AWSRequestMetrics.Field.Exception);
        long throttles = S3RequestRetryStats.getCounter(info, AWSRequestMetrics.Field.ThrottleException);
        this.requests.addAndGet(requests);
        this.exceptions.addAndGet(exceptions);
        this.throttles.addAndGet(throttles);
        if (exceptions >= 0L && exceptions < (long)this.exceptionsHistogram.length()) {
            this.exceptionsHistogram.incrementAndGet((int)exceptions);
        }
        if (throttles >= 0L && throttles < (long)this.throttlesHistogram.length()) {
            this.throttlesHistogram.incrementAndGet((int)throttles);
        }
    }

    private static long getCounter(TimingInfo info, AWSRequestMetrics.Field field) {
        Number counter = info.getCounter(field.name());
        return counter != null ? counter.longValue() : 0L;
    }

    public void emitMetrics() {
        if (logger.isDebugEnabled()) {
            int i;
            Map metrics = Maps.newMapWithExpectedSize((int)4);
            metrics.put(MESSAGE_FIELD, "S3 Request Retry Stats");
            metrics.put("elasticsearch.metrics.s3.requests", this.requests.get());
            metrics.put("elasticsearch.metrics.s3.exceptions", this.exceptions.get());
            metrics.put("elasticsearch.metrics.s3.throttles", this.throttles.get());
            for (i = 0; i < this.exceptionsHistogram.length(); ++i) {
                long exceptions = this.exceptionsHistogram.get(i);
                if (exceptions == 0L) continue;
                metrics.put("elasticsearch.metrics.s3.exceptions_histogram_" + i, exceptions);
            }
            for (i = 0; i < this.throttlesHistogram.length(); ++i) {
                long throttles = this.throttlesHistogram.get(i);
                if (throttles == 0L) continue;
                metrics.put("elasticsearch.metrics.s3.throttles_histogram_" + i, throttles);
            }
            logger.debug((Message)new ESLogMessage().withFields(metrics));
        }
    }
}

