/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.async;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.StoredAsyncResponse;
import org.elasticsearch.xpack.core.async.StoredAsyncTask;

public class AsyncTaskManagementService<Request extends TaskAwareRequest, Response extends ActionResponse, T extends StoredAsyncTask<Response>> {
    private static final Logger logger = LogManager.getLogger(AsyncTaskManagementService.class);
    private final TaskManager taskManager;
    private final String action;
    private final AsyncTaskIndexService<StoredAsyncResponse<Response>> asyncTaskIndexService;
    private final AsyncOperation<Request, Response, T> operation;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Class<T> taskClass;

    public AsyncTaskManagementService(String index, Client client, String origin, NamedWriteableRegistry registry, TaskManager taskManager, String action, AsyncOperation<Request, Response, T> operation, Class<T> taskClass, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays) {
        this.taskManager = taskManager;
        this.action = action;
        this.operation = operation;
        this.taskClass = taskClass;
        this.asyncTaskIndexService = new AsyncTaskIndexService(index, clusterService, threadPool.getThreadContext(), client, origin, i -> new StoredAsyncResponse(operation::readResponse, i), registry, bigArrays);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExecute(Request request, TimeValue waitForCompletionTimeout, TimeValue keepAlive, boolean keepOnCompletion, ActionListener<Response> listener) {
        String nodeId = this.clusterService.localNode().getId();
        try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
            StoredAsyncTask searchTask = (StoredAsyncTask)this.taskManager.register("transport", this.action + "[a]", (TaskAwareRequest)new AsyncRequestWrapper(this, request, nodeId));
            boolean operationStarted = false;
            try {
                this.operation.execute(request, searchTask, this.wrapStoringListener(searchTask, waitForCompletionTimeout, keepAlive, keepOnCompletion, listener));
                operationStarted = true;
            }
            finally {
                if (!operationStarted) {
                    this.taskManager.unregister((Task)searchTask);
                }
            }
        }
    }

    private ActionListener<Response> wrapStoringListener(T searchTask, TimeValue waitForCompletionTimeout, TimeValue keepAlive, boolean keepOnCompletion, ActionListener<Response> listener) {
        AtomicReference<ActionListener<Response>> exclusiveListener = new AtomicReference<ActionListener<Response>>(listener);
        Scheduler.ScheduledCancellable timeoutHandler = this.threadPool.schedule(() -> {
            ActionListener acquiredListener = exclusiveListener.getAndSet(null);
            if (acquiredListener != null) {
                acquiredListener.onResponse(this.operation.initialResponse((StoredAsyncTask)searchTask));
            }
        }, waitForCompletionTimeout, (Executor)this.threadPool.executor("search"));
        return ActionListener.wrap(response -> {
            ActionListener acquiredListener = exclusiveListener.getAndSet(null);
            if (acquiredListener != null) {
                timeoutHandler.cancel();
                if (keepOnCompletion) {
                    this.storeResults(searchTask, new StoredAsyncResponse((Writeable)response, this.threadPool.absoluteTimeInMillis() + keepAlive.getMillis()), (ActionListener<Void>)ActionListener.running(() -> acquiredListener.onResponse(response)));
                } else {
                    this.taskManager.unregister((Task)searchTask);
                    searchTask.onResponse(response);
                    acquiredListener.onResponse(response);
                }
            } else {
                this.storeResults(searchTask, new StoredAsyncResponse((Writeable)response, this.threadPool.absoluteTimeInMillis() + keepAlive.getMillis()));
            }
        }, e -> {
            ActionListener acquiredListener = exclusiveListener.getAndSet(null);
            if (acquiredListener != null) {
                timeoutHandler.cancel();
                if (keepOnCompletion) {
                    this.storeResults(searchTask, new StoredAsyncResponse(e, this.threadPool.absoluteTimeInMillis() + keepAlive.getMillis()), (ActionListener<Void>)ActionListener.running(() -> acquiredListener.onFailure(e)));
                } else {
                    this.taskManager.unregister((Task)searchTask);
                    searchTask.onFailure(e);
                    acquiredListener.onFailure(e);
                }
            } else {
                this.storeResults(searchTask, new StoredAsyncResponse(e, this.threadPool.absoluteTimeInMillis() + keepAlive.getMillis()));
            }
        });
    }

    private void storeResults(T searchTask, StoredAsyncResponse<Response> storedResponse) {
        this.storeResults(searchTask, storedResponse, null);
    }

    private void storeResults(T searchTask, StoredAsyncResponse<Response> storedResponse, ActionListener<Void> finalListener) {
        try {
            this.asyncTaskIndexService.createResponseForEQL(searchTask.getExecutionId().getDocId(), searchTask.getOriginHeaders(), storedResponse, ActionListener.wrap(resp -> {
                logger.trace(() -> "stored eql search results for [" + searchTask.getExecutionId().getEncoded() + "]");
                this.taskManager.unregister((Task)searchTask);
                if (storedResponse.getException() != null) {
                    searchTask.onFailure(storedResponse.getException());
                } else {
                    searchTask.onResponse((ActionResponse)storedResponse.getResponse());
                }
                if (finalListener != null) {
                    finalListener.onResponse(null);
                }
            }, exc -> {
                this.taskManager.unregister((Task)searchTask);
                searchTask.onFailure(exc);
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exc);
                if (!(cause instanceof DocumentMissingException) && !(cause instanceof VersionConflictEngineException)) {
                    logger.error(() -> Strings.format((String)"failed to store eql search results for [%s]", (Object[])new Object[]{searchTask.getExecutionId().getEncoded()}), (Throwable)exc);
                }
                if (finalListener != null) {
                    finalListener.onFailure(exc);
                }
            }));
        }
        catch (Exception exc2) {
            this.taskManager.unregister(searchTask);
            searchTask.onFailure(exc2);
            logger.error(() -> "failed to store eql search results for [" + searchTask.getExecutionId().getEncoded() + "]", (Throwable)exc2);
        }
    }

    public static <Response extends ActionResponse, Task extends StoredAsyncTask<Response>> void addCompletionListener(ThreadPool threadPool, Task task, ActionListener<StoredAsyncResponse<Response>> listener, TimeValue timeout) {
        if (timeout.getMillis() <= 0L) {
            AsyncTaskManagementService.getCurrentResult(task, listener);
        } else {
            task.addCompletionListener(ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (TimeValue)timeout, (Executor)threadPool.executor("search"), (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)new StoredAsyncResponse((Writeable)r, task.getExpirationTimeMillis())), e -> listener.onResponse((Object)new StoredAsyncResponse(e, task.getExpirationTimeMillis()))), wrapper -> {
                task.removeCompletionListener(wrapper);
                AsyncTaskManagementService.getCurrentResult(task, listener);
            }));
        }
    }

    private static <Response extends ActionResponse, Task extends StoredAsyncTask<Response>> void getCurrentResult(Task task, ActionListener<StoredAsyncResponse<Response>> listener) {
        try {
            listener.onResponse((Object)new StoredAsyncResponse((Writeable)task.getCurrentResult(), task.getExpirationTimeMillis()));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public static interface AsyncOperation<Request extends TaskAwareRequest, Response extends ActionResponse, T extends CancellableTask> {
        public T createTask(Request var1, long var2, String var4, String var5, TaskId var6, Map<String, String> var7, Map<String, String> var8, AsyncExecutionId var9);

        public void execute(Request var1, T var2, ActionListener<Response> var3);

        public Response initialResponse(T var1);

        public Response readResponse(StreamInput var1) throws IOException;
    }

    private static class AsyncRequestWrapper
    implements TaskAwareRequest {
        private final Request request;
        private final String doc;
        private final String node;
        final /* synthetic */ AsyncTaskManagementService this$0;

        AsyncRequestWrapper(Request request, String node) {
            this.this$0 = var1_1;
            this.request = request;
            this.doc = UUIDs.randomBase64UUID();
            this.node = node;
        }

        public void setParentTask(TaskId taskId) {
            this.request.setParentTask(taskId);
        }

        public TaskId getParentTask() {
            return this.request.getParentTask();
        }

        public void setRequestId(long requestId) {
            this.request.setRequestId(requestId);
        }

        public long getRequestId() {
            return this.request.getRequestId();
        }

        public Task createTask(long id, String type, String actionName, TaskId parentTaskId, Map<String, String> headers) {
            Map originHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.this$0.threadPool.getThreadContext(), (ClusterState)this.this$0.clusterService.state());
            return this.this$0.operation.createTask(this.request, id, type, actionName, parentTaskId, headers, originHeaders, new AsyncExecutionId(this.doc, new TaskId(this.node, id)));
        }

        public String getDescription() {
            return this.request.getDescription();
        }
    }
}

