/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

final class StackTrace
implements ToXContentObject {
    static final int NATIVE_FRAME_TYPE = 3;
    static final int KERNEL_FRAME_TYPE = 4;
    List<Integer> addressOrLines;
    List<String> fileIds;
    List<String> frameIds;
    List<Integer> typeIds;
    double annualCO2Tons;
    double annualCostsUSD;
    long count;
    private static final int BASE64_FRAME_ID_LENGTH = 32;
    private static final String SAFE_BASE64_ENCODER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234456789-_";
    private static final int[] SAFE_BASE64_DECODER = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 63, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    StackTrace(List<Integer> addressOrLines, List<String> fileIds, List<String> frameIds, List<Integer> typeIds, double annualCO2Tons, double annualCostsUSD, long count) {
        this.addressOrLines = addressOrLines;
        this.fileIds = fileIds;
        this.frameIds = frameIds;
        this.typeIds = typeIds;
        this.annualCO2Tons = annualCO2Tons;
        this.annualCostsUSD = annualCostsUSD;
        this.count = count;
    }

    static List<Integer> runLengthDecodeBase64Url(String input, int size, int capacity) {
        int value;
        int count;
        int n;
        int i;
        Object[] output = new Integer[capacity];
        int multipleOf8 = size / 8;
        int remainder = size % 8;
        int j = 0;
        for (i = 0; i < multipleOf8 * 8; i += 8) {
            n = StackTrace.charCodeAt(input, i) << 26 | StackTrace.charCodeAt(input, i + 1) << 20 | StackTrace.charCodeAt(input, i + 2) << 14 | StackTrace.charCodeAt(input, i + 3) << 8 | StackTrace.charCodeAt(input, i + 4) << 2 | StackTrace.charCodeAt(input, i + 5) >> 4;
            count = n >> 24 & 0xFF;
            value = n >> 16 & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
            n = (StackTrace.charCodeAt(input, i + 5) & 0xF) << 12 | StackTrace.charCodeAt(input, i + 6) << 6 | StackTrace.charCodeAt(input, i + 7);
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
        }
        if (remainder == 6) {
            n = StackTrace.charCodeAt(input, i) << 26 | StackTrace.charCodeAt(input, i + 1) << 20 | StackTrace.charCodeAt(input, i + 2) << 14 | StackTrace.charCodeAt(input, i + 3) << 8 | StackTrace.charCodeAt(input, i + 4) << 2 | StackTrace.charCodeAt(input, i + 5) >> 4;
            count = n >> 24 & 0xFF;
            value = n >> 16 & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
        } else if (remainder == 3) {
            n = StackTrace.charCodeAt(input, i) << 12 | StackTrace.charCodeAt(input, i + 1) << 6 | StackTrace.charCodeAt(input, i + 2);
            count = (n >>= 2) >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, (Object)value);
            j += count;
        }
        if (j < capacity) {
            Arrays.fill(output, j, capacity, (Object)0);
        }
        return Arrays.asList(output);
    }

    static int getAddressFromStackFrameID(String frameID) {
        int address = StackTrace.charCodeAt(frameID, 21) & 0xF;
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 22);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 23);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 24);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 25);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 26);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 27);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 28);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 29);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 30);
        address <<= 6;
        return address += StackTrace.charCodeAt(frameID, 31);
    }

    private static int charCodeAt(String input, int i) {
        return SAFE_BASE64_DECODER[input.charAt(i) & 0x7F];
    }

    static String getFileIDFromStackFrameID(String frameID) {
        return frameID.substring(0, 21) + SAFE_BASE64_ENCODER.charAt(frameID.charAt(21) & 0x30);
    }

    public static StackTrace fromSource(Map<String, Object> source) {
        String inputFrameIDs = (String)ObjectPath.eval((String)"Stacktrace.frame.ids", source);
        String inputFrameTypes = (String)ObjectPath.eval((String)"Stacktrace.frame.types", source);
        int countsFrameIDs = inputFrameIDs.length() / 32;
        ArrayList<String> fileIDs = new ArrayList<String>(countsFrameIDs);
        ArrayList<String> frameIDs = new ArrayList<String>(countsFrameIDs);
        ArrayList<Integer> addressOrLines = new ArrayList<Integer>(countsFrameIDs);
        int i = 0;
        int pos = 0;
        while (i < countsFrameIDs) {
            String frameID = inputFrameIDs.substring(pos, pos + 32);
            frameIDs.add(frameID);
            fileIDs.add(StackTrace.getFileIDFromStackFrameID(frameID));
            addressOrLines.add(StackTrace.getAddressFromStackFrameID(frameID));
            ++i;
            pos += 32;
        }
        List<Integer> typeIDs = StackTrace.runLengthDecodeBase64Url(inputFrameTypes, inputFrameTypes.length(), countsFrameIDs);
        return new StackTrace(addressOrLines, fileIDs, frameIDs, typeIDs, 0.0, 0.0, 0L);
    }

    public void forNativeAndKernelFrames(Consumer<String> consumer) {
        for (int i = 0; i < this.fileIds.size(); ++i) {
            Integer frameType = this.typeIds.get(i);
            if (frameType == null || frameType != 3 && frameType != 4) continue;
            consumer.accept(this.fileIds.get(i));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("address_or_lines", this.addressOrLines);
        builder.field("file_ids", this.fileIds);
        builder.field("frame_ids", this.frameIds);
        builder.field("type_ids", this.typeIds);
        builder.field("annual_co2_tons", this.annualCO2Tons);
        builder.field("annual_costs_usd", this.annualCostsUSD);
        builder.field("count", this.count);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTrace that = (StackTrace)o;
        return this.addressOrLines.equals(that.addressOrLines) && this.fileIds.equals(that.fileIds) && this.frameIds.equals(that.frameIds) && this.typeIds.equals(that.typeIds);
    }

    public int hashCode() {
        return Objects.hash(this.addressOrLines, this.fileIds, this.frameIds, this.typeIds);
    }
}

