/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureTransportAction;
import org.elasticsearch.xpack.profiling.ProfilingLicenseChecker;

public class ProfilingInfoTransportAction
extends XPackInfoFeatureTransportAction {
    private final boolean enabled;
    private final ProfilingLicenseChecker licenseChecker;

    @Inject
    public ProfilingInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, ProfilingLicenseChecker licenseChecker) {
        super(XPackInfoFeatureAction.UNIVERSAL_PROFILING.name(), transportService, actionFilters);
        this.enabled = (Boolean)XPackSettings.PROFILING_ENABLED.get(settings);
        this.licenseChecker = licenseChecker;
    }

    public String name() {
        return "universal_profiling";
    }

    public boolean available() {
        return this.licenseChecker.isSupportedLicense();
    }

    public boolean enabled() {
        return this.enabled;
    }
}

