/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.profiling.StackFrame;
import org.elasticsearch.xpack.profiling.StackTrace;
import org.elasticsearch.xpack.profiling.TraceEvent;

public class GetStackTracesResponse
extends ActionResponse
implements ChunkedToXContentObject {
    @Nullable
    private final Map<String, StackTrace> stackTraces;
    @Nullable
    private final Map<String, StackFrame> stackFrames;
    @Nullable
    private final Map<String, String> executables;
    @Nullable
    private final Map<String, TraceEvent> stackTraceEvents;
    private final int totalFrames;
    private final double samplingRate;
    private final long totalSamples;

    public GetStackTracesResponse(StreamInput in) throws IOException {
        this.stackTraces = in.readBoolean() ? in.readMap(i -> new StackTrace(i.readCollectionAsList(StreamInput::readInt), i.readCollectionAsList(StreamInput::readString), i.readCollectionAsList(StreamInput::readString), i.readCollectionAsList(StreamInput::readInt), i.readDouble(), i.readDouble(), i.readLong())) : null;
        this.stackFrames = in.readBoolean() ? in.readMap(i -> new StackFrame(i.readCollectionAsList(StreamInput::readString), i.readCollectionAsList(StreamInput::readString), i.readCollectionAsList(StreamInput::readInt), i.readCollectionAsList(StreamInput::readInt))) : null;
        this.executables = in.readBoolean() ? in.readMap(StreamInput::readString) : null;
        this.stackTraceEvents = in.readBoolean() ? in.readMap(i -> new TraceEvent(i.readString(), i.readLong())) : null;
        this.totalFrames = in.readInt();
        this.samplingRate = in.readDouble();
        this.totalSamples = in.readLong();
    }

    public GetStackTracesResponse(Map<String, StackTrace> stackTraces, Map<String, StackFrame> stackFrames, Map<String, String> executables, Map<String, TraceEvent> stackTraceEvents, int totalFrames, double samplingRate, long totalSamples) {
        this.stackTraces = stackTraces;
        this.stackFrames = stackFrames;
        this.executables = executables;
        this.stackTraceEvents = stackTraceEvents;
        this.totalFrames = totalFrames;
        this.samplingRate = samplingRate;
        this.totalSamples = totalSamples;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.stackTraces != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraces, (o, v) -> {
                o.writeCollection(v.addressOrLines, StreamOutput::writeInt);
                o.writeStringCollection(v.fileIds);
                o.writeStringCollection(v.frameIds);
                o.writeCollection(v.typeIds, StreamOutput::writeInt);
                o.writeDouble(v.annualCO2Tons);
                o.writeDouble(v.annualCostsUSD);
                o.writeLong(v.count);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.stackFrames != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackFrames, (o, v) -> {
                o.writeStringCollection(v.fileName);
                o.writeStringCollection(v.functionName);
                o.writeCollection(v.functionOffset, StreamOutput::writeInt);
                o.writeCollection(v.lineNumber, StreamOutput::writeInt);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.executables != null) {
            out.writeBoolean(true);
            out.writeMap(this.executables, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.stackTraceEvents != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraceEvents, (o, v) -> {
                o.writeString(v.stacktraceID);
                o.writeLong(v.count);
            });
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalFrames);
        out.writeDouble(this.samplingRate);
        out.writeLong(this.totalSamples);
    }

    public Map<String, StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public Map<String, String> getExecutables() {
        return this.executables;
    }

    public Map<String, TraceEvent> getStackTraceEvents() {
        return this.stackTraceEvents;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), GetStackTracesResponse.optional("stack_traces", this.stackTraces, ChunkedToXContentHelper::xContentValuesMap), GetStackTracesResponse.optional("stack_frames", this.stackFrames, ChunkedToXContentHelper::xContentValuesMap), GetStackTracesResponse.optional("executables", this.executables, ChunkedToXContentHelper::map), GetStackTracesResponse.optional("stack_trace_events", this.stackTraceEvents, (n, v) -> ChunkedToXContentHelper.map((String)n, (Map)v, entry -> (b, p) -> b.field((String)entry.getKey(), ((TraceEvent)entry.getValue()).count))), Iterators.single((b, p) -> b.field("total_frames", this.totalFrames)), Iterators.single((b, p) -> b.field("sampling_rate", this.samplingRate)), ChunkedToXContentHelper.endObject()});
    }

    private static <T> Iterator<? extends ToXContent> optional(String name, Map<String, T> values, BiFunction<String, Map<String, T>, Iterator<? extends ToXContent>> supplier) {
        return values != null ? supplier.apply(name, values) : Collections.emptyIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetStackTracesResponse response = (GetStackTracesResponse)((Object)o);
        return this.totalFrames == response.totalFrames && this.samplingRate == response.samplingRate && Objects.equals(this.stackTraces, response.stackTraces) && Objects.equals(this.stackFrames, response.stackFrames) && Objects.equals(this.executables, response.executables) && Objects.equals(this.stackTraceEvents, response.stackTraceEvents);
    }

    public int hashCode() {
        return Objects.hash(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.samplingRate);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this, (boolean)true, (boolean)true);
    }
}

