/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.Map;
import org.elasticsearch.xpack.profiling.CostEntry;
import org.elasticsearch.xpack.profiling.HostMetadata;
import org.elasticsearch.xpack.profiling.InstanceTypeService;

final class CostCalculator {
    private static final double DEFAULT_SAMPLING_FREQUENCY = 20.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final double SECONDS_PER_YEAR = 3.1536E7;
    private static final double DEFAULT_COST_USD_PER_CORE_HOUR = 0.0425;
    private static final double DEFAULT_AWS_COST_FACTOR = 1.0;
    private final Map<String, HostMetadata> hostMetadata;
    private final double samplingDurationInSeconds;
    private final double awsCostFactor;
    private final double customCostPerCoreHour;

    CostCalculator(Map<String, HostMetadata> hostMetadata, double samplingDurationInSeconds, Double awsCostFactor, Double customCostPerCoreHour) {
        this.hostMetadata = hostMetadata;
        this.samplingDurationInSeconds = samplingDurationInSeconds > 0.0 ? samplingDurationInSeconds : 1.0;
        this.awsCostFactor = awsCostFactor == null ? 1.0 : awsCostFactor;
        this.customCostPerCoreHour = customCostPerCoreHour == null ? 0.0425 : customCostPerCoreHour;
    }

    public double annualCostsUSD(String hostID, double samples) {
        double annualCoreHours = CostCalculator.annualCoreHours(this.samplingDurationInSeconds, samples, 20.0);
        HostMetadata host = this.hostMetadata.get(hostID);
        if (host == null) {
            return annualCoreHours * this.customCostPerCoreHour;
        }
        double providerCostFactor = host.instanceType.provider.equals("aws") ? this.awsCostFactor : 1.0;
        CostEntry costs = InstanceTypeService.getCosts(host.instanceType);
        if (costs == null) {
            return annualCoreHours * this.customCostPerCoreHour * providerCostFactor;
        }
        return annualCoreHours * costs.costFactor * providerCostFactor;
    }

    public static double annualCoreHours(double duration, double samples, double samplingFrequency) {
        return 3.1536E7 / duration * samples / samplingFrequency / 3600.0;
    }
}

