/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.operation;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.function.IntSupplier;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.DOT;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure2D;

public class MultiplyRight
implements MatrixOperation {
    public static IntSupplier PARALLELISM = Parallelism.THREADS;
    public static int THRESHOLD = 32;
    private static final DivideAndConquer.Divider DIVIDER = ProcessingService.INSTANCE.divider();

    public static <N extends Scalar<N>> Generic<N> newGeneric(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMxN_MT(org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar[] int org.ojalgo.structure.Access1D org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        if (columns == 1L) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMx1(org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar[] int org.ojalgo.structure.Access1D org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        if (rows == 1L) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V, fill1xN(org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar[] int org.ojalgo.structure.Access1D org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMxN(org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar[] int org.ojalgo.structure.Access1D org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;[Lorg/ojalgo/scalar/Scalar;ILorg/ojalgo/structure/Access1D;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
    }

    public static Primitive32 newPrimitive32(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return MultiplyRight::fillMxN_MT;
        }
        if (columns == 1L) {
            return MultiplyRight::fillMx1;
        }
        if (rows == 1L) {
            return MultiplyRight::fill1xN;
        }
        return MultiplyRight::fillMxN;
    }

    public static Primitive64 newPrimitive64(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return MultiplyRight::fillMxN_MT;
        }
        if (rows == 5L && columns == 5L) {
            return MultiplyRight::fill5x5;
        }
        if (rows == 4L && columns == 4L) {
            return MultiplyRight::fill4x4;
        }
        if (rows == 3L && columns == 3L) {
            return MultiplyRight::fill3x3;
        }
        if (rows == 2L && columns == 2L) {
            return MultiplyRight::fill2x2;
        }
        if (rows == 1L && columns == 1L) {
            return MultiplyRight::fill1x1;
        }
        if (columns == 1L) {
            return MultiplyRight::fillMx1;
        }
        if (rows == 10L) {
            return MultiplyRight::fill0xN;
        }
        if (rows == 9L) {
            return MultiplyRight::fill9xN;
        }
        if (rows == 8L) {
            return MultiplyRight::fill8xN;
        }
        if (rows == 7L) {
            return MultiplyRight::fill7xN;
        }
        if (rows == 6L) {
            return MultiplyRight::fill6xN;
        }
        if (rows == 1L) {
            return MultiplyRight::fill1xN;
        }
        return MultiplyRight::fillMxN;
    }

    private static void base(double[] product, double[] left, int complexity, Access1D<?> right) {
        int nbRows = left.length / complexity;
        int nbCols = Math.toIntExact(right.count() / (long)complexity);
        for (int i = 0; i < nbRows; ++i) {
            for (int c = 0; c < complexity; ++c) {
                for (int j = 0; j < nbCols; ++j) {
                    int n = i + j * nbRows;
                    product[n] = product[n] + left[i + c * nbRows] * right.doubleValue(Structure2D.index(complexity, c, j));
                }
            }
        }
    }

    static void add1xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int nbCols = product.length;
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, 0);
            int limitOfCol = Structure2D.firstInColumn(right, j, complexity);
            int n = j;
            product[n] = product[n] + DOT.invoke(left, 0, right, j * complexity, firstInCol, limitOfCol);
        }
    }

    static void add1xN(float[] product, float[] left, int complexity, Access1D<?> right) {
        int nbCols = product.length;
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, 0);
            int limitOfCol = Structure2D.firstInColumn(right, j, complexity);
            int n = j;
            product[n] = product[n] + DOT.invoke(left, 0, right, j * complexity, firstInCol, limitOfCol);
        }
    }

    static void addMx1(double[] product, double[] left, int complexity, Access1D<?> right) {
        int nbRows = product.length;
        for (int c = 0; c < complexity; ++c) {
            AXPY.invoke(product, 0, right.doubleValue(c), left, c * nbRows, 0, nbRows);
        }
    }

    static void addMx1(float[] product, float[] left, int complexity, Access1D<?> right) {
        int nbRows = product.length;
        for (int c = 0; c < complexity; ++c) {
            AXPY.invoke(product, 0, right.floatValue(c), left, c * nbRows, 0, nbRows);
        }
    }

    static <N extends Scalar<N>> void addMx1(N[] product, N[] left, int complexity, Access1D<N> right) {
        int nbRows = product.length;
        for (int c = 0; c < complexity; ++c) {
            AXPY.invoke(product, (int)0, (Scalar)((Scalar)right.get(c)), left, (int)(c * nbRows), (int)0, (int)nbRows);
        }
    }

    static void addMxC(double[] product, int firstColumn, int columnLimit, double[] left, int complexity, Access1D<?> right) {
        int nbRows = left.length / complexity;
        for (int j = firstColumn; j < columnLimit; ++j) {
            for (int c = 0; c < complexity; ++c) {
                double a = right.doubleValue(Structure2D.index(complexity, c, j));
                if (a == 0.0) continue;
                AXPY.invoke(product, j * nbRows, a, left, c * nbRows, 0, nbRows);
            }
        }
    }

    static void addMxC(float[] product, int firstColumn, int columnLimit, float[] left, int complexity, Access1D<?> right) {
        int nbRows = left.length / complexity;
        for (int j = firstColumn; j < columnLimit; ++j) {
            for (int c = 0; c < complexity; ++c) {
                float a = right.floatValue(Structure2D.index(complexity, c, j));
                if (a == 0.0f) continue;
                AXPY.invoke(product, j * nbRows, a, left, c * nbRows, 0, nbRows);
            }
        }
    }

    static <N extends Scalar<N>> void addMxC(N[] product, int firstColumn, int columnLimit, N[] left, int complexity, Access1D<N> right) {
        int nbRows = left.length / complexity;
        for (int j = firstColumn; j < columnLimit; ++j) {
            for (int c = 0; c < complexity; ++c) {
                Scalar a = (Scalar)right.get(Structure2D.index(complexity, c, j));
                if (a.isSmall(1.0)) continue;
                AXPY.invoke(product, (int)(j * nbRows), (Scalar)a, left, (int)(c * nbRows), (int)0, (int)nbRows);
            }
        }
    }

    static void addMxN_MT(double[] product, double[] left, int complexity, Access1D<?> right) {
        MultiplyRight.divide(0, Math.toIntExact(right.count() / (long)complexity), (f, l) -> MultiplyRight.addMxC(product, f, l, left, complexity, right));
    }

    static void addMxN_MT(float[] product, float[] left, int complexity, Access1D<?> right) {
        MultiplyRight.divide(0, Math.toIntExact(right.count() / (long)complexity), (f, l) -> MultiplyRight.addMxC(product, f, l, left, complexity, right));
    }

    static <N extends Scalar<N>> void addMxN_MT(N[] product, N[] left, int complexity, Access1D<N> right) {
        MultiplyRight.divide(0, Math.toIntExact(right.count() / (long)complexity), (f, l) -> MultiplyRight.addMxC((Scalar[])product, (int)f, (int)l, (Scalar[])left, (int)complexity, (Access1D)right));
    }

    static void divide(int first, int limit, DivideAndConquer.Conquerer conquerer) {
        DIVIDER.parallelism(PARALLELISM).threshold(THRESHOLD).divide(first, limit, conquerer);
    }

    static void fill0xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = 10;
        int tmpColDim = product.length / tmpRowDim;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            double tmp9J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
                tmp8J += left[tmpIndex++] * tmpRightCJ;
                tmp9J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
            product[++tmpIndex] = tmp9J;
        }
    }

    static void fill1x1(double[] product, double[] left, int complexity, Access1D<?> right) {
        double tmp00 = PrimitiveMath.ZERO;
        int tmpLeftStruct = left.length / complexity;
        for (int c = 0; c < complexity; ++c) {
            tmp00 += left[c * tmpLeftStruct] * right.doubleValue(c);
        }
        product[0] = tmp00;
    }

    static void fill1xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int nbCols = product.length;
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, 0);
            int limitOfCol = Structure2D.firstInColumn(right, j, complexity);
            product[j] = DOT.invoke(left, 0, right, j * complexity, firstInCol, limitOfCol);
        }
    }

    static void fill1xN(float[] product, float[] left, int complexity, Access1D<?> right) {
        int nbCols = product.length;
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, 0);
            int limitOfCol = Structure2D.firstInColumn(right, j, complexity);
            product[j] = DOT.invoke(left, 0, right, j * complexity, firstInCol, limitOfCol);
        }
    }

    static <N extends Scalar<N>> void fill1xN(N[] product, N[] left, int complexity, Access1D<N> right, Scalar.Factory<N> scalar) {
        int nbCols = product.length;
        for (int j = 0; j < nbCols; ++j) {
            int firstInCol = Structure2D.firstInColumn(right, j, 0);
            int limitOfCol = Structure2D.firstInColumn(right, j, complexity);
            product[j] = DOT.invoke(left, (int)0, right, (int)(j * complexity), (int)firstInCol, (int)limitOfCol, scalar);
        }
    }

    static void fill2x2(double[] product, double[] left, int complexity, Access1D<?> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 2;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp01;
        product[3] = tmp11;
    }

    static void fill3x3(double[] product, double[] left, int complexity, Access1D<?> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 3;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp01;
        product[4] = tmp11;
        product[5] = tmp21;
        product[6] = tmp02;
        product[7] = tmp12;
        product[8] = tmp22;
    }

    static void fill4x4(double[] product, double[] left, int complexity, Access1D<?> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 4;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            double tmpLeft3 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp01;
        product[5] = tmp11;
        product[6] = tmp21;
        product[7] = tmp31;
        product[8] = tmp02;
        product[9] = tmp12;
        product[10] = tmp22;
        product[11] = tmp32;
        product[12] = tmp03;
        product[13] = tmp13;
        product[14] = tmp23;
        product[15] = tmp33;
    }

    static void fill5x5(double[] product, double[] left, int complexity, Access1D<?> right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp40 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp41 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp42 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        double tmp43 = PrimitiveMath.ZERO;
        double tmp04 = PrimitiveMath.ZERO;
        double tmp14 = PrimitiveMath.ZERO;
        double tmp24 = PrimitiveMath.ZERO;
        double tmp34 = PrimitiveMath.ZERO;
        double tmp44 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 5;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            double tmpLeft3 = left[++tmpIndex];
            double tmpLeft4 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += complexity);
            double tmpRight4 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp40 += tmpLeft4 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp41 += tmpLeft4 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp42 += tmpLeft4 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
            tmp43 += tmpLeft4 * tmpRight3;
            tmp04 += tmpLeft0 * tmpRight4;
            tmp14 += tmpLeft1 * tmpRight4;
            tmp24 += tmpLeft2 * tmpRight4;
            tmp34 += tmpLeft3 * tmpRight4;
            tmp44 += tmpLeft4 * tmpRight4;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp40;
        product[5] = tmp01;
        product[6] = tmp11;
        product[7] = tmp21;
        product[8] = tmp31;
        product[9] = tmp41;
        product[10] = tmp02;
        product[11] = tmp12;
        product[12] = tmp22;
        product[13] = tmp32;
        product[14] = tmp42;
        product[15] = tmp03;
        product[16] = tmp13;
        product[17] = tmp23;
        product[18] = tmp33;
        product[19] = tmp43;
        product[20] = tmp04;
        product[21] = tmp14;
        product[22] = tmp24;
        product[23] = tmp34;
        product[24] = tmp44;
    }

    static void fill6xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = 6;
        int tmpColDim = product.length / tmpRowDim;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
        }
    }

    static void fill7xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = 7;
        int tmpColDim = product.length / tmpRowDim;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
        }
    }

    static void fill8xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = 8;
        int tmpColDim = product.length / tmpRowDim;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
        }
    }

    static void fill9xN(double[] product, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = 9;
        int tmpColDim = product.length / tmpRowDim;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(Structure2D.index(complexity, c, j));
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
                tmp8J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
        }
    }

    static void fillMx1(double[] product, double[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0);
        MultiplyRight.addMx1(product, left, complexity, right);
    }

    static void fillMx1(float[] product, float[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0f);
        MultiplyRight.addMx1(product, left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMx1(N[] product, N[] left, int complexity, Access1D<N> right, Scalar.Factory<N> scalar) {
        Arrays.fill(product, scalar.zero().get());
        MultiplyRight.addMx1(product, left, (int)complexity, right);
    }

    static void fillMxN(double[] product, double[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0);
        MultiplyRight.addMxC(product, 0, Math.toIntExact(right.count() / (long)complexity), left, complexity, right);
    }

    static void fillMxN(float[] product, float[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0f);
        MultiplyRight.addMxC(product, 0, Math.toIntExact(right.count() / (long)complexity), left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMxN(N[] product, N[] left, int complexity, Access1D<N> right, Scalar.Factory<N> scalar) {
        Arrays.fill(product, scalar.zero().get());
        MultiplyRight.addMxC(product, (int)0, (int)Math.toIntExact(right.count() / (long)complexity), left, (int)complexity, right);
    }

    static void fillMxN_MT(double[] product, double[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0);
        MultiplyRight.addMxN_MT(product, left, complexity, right);
    }

    static void fillMxN_MT(float[] product, float[] left, int complexity, Access1D<?> right) {
        Arrays.fill(product, 0.0f);
        MultiplyRight.addMxN_MT(product, left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMxN_MT(N[] product, N[] left, int complexity, Access1D<N> right, Scalar.Factory<N> scalar) {
        Arrays.fill(product, scalar.zero().get());
        MultiplyRight.addMxN_MT(product, left, (int)complexity, right);
    }

    @FunctionalInterface
    public static interface Primitive64 {
        public void invoke(double[] var1, double[] var2, int var3, Access1D<?> var4);
    }

    @FunctionalInterface
    public static interface Primitive32 {
        public void invoke(float[] var1, float[] var2, int var3, Access1D<?> var4);
    }

    @FunctionalInterface
    public static interface Generic<N extends Scalar<N>> {
        public void invoke(N[] var1, N[] var2, int var3, Access1D<N> var4, Scalar.Factory<N> var5);
    }
}

