/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.util.List;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.structure.Access2D;

public interface Provider2D {

    @FunctionalInterface
    public static interface Trace<N extends Comparable<N>>
    extends Provider2D {
        public N getTrace();
    }

    @FunctionalInterface
    public static interface Symmetric
    extends Provider2D {
        public boolean isSymmetric();
    }

    @FunctionalInterface
    public static interface Solution<M>
    extends Provider2D {
        public M solve(Access2D<?> var1);
    }

    @FunctionalInterface
    public static interface Rank
    extends Provider2D {
        public int getRank();
    }

    @FunctionalInterface
    public static interface Inverse<M>
    extends Provider2D {
        public M invert();
    }

    @FunctionalInterface
    public static interface Hermitian
    extends Provider2D {
        public boolean isHermitian();
    }

    @FunctionalInterface
    public static interface Eigenpairs
    extends Provider2D {
        public List<Eigenvalue.Eigenpair> getEigenpairs();
    }

    @FunctionalInterface
    public static interface Determinant<N extends Comparable<N>>
    extends Provider2D {
        public N getDeterminant();
    }

    @FunctionalInterface
    public static interface Condition
    extends Provider2D {
        public double getCondition();
    }
}

