/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;

public class TransformCheckpointStats
implements Writeable,
ToXContentObject {
    public static final TransformCheckpointStats EMPTY = new TransformCheckpointStats(0L, null, null, 0L, 0L);
    private final long checkpoint;
    private final TransformIndexerPosition position;
    private final TransformProgress checkpointProgress;
    private final long timestampMillis;
    private final long timeUpperBoundMillis;

    public TransformCheckpointStats(long checkpoint, TransformIndexerPosition position, TransformProgress checkpointProgress, long timestampMillis, long timeUpperBoundMillis) {
        this.checkpoint = checkpoint;
        this.position = position;
        this.checkpointProgress = checkpointProgress;
        this.timestampMillis = timestampMillis;
        this.timeUpperBoundMillis = timeUpperBoundMillis;
    }

    public TransformCheckpointStats(StreamInput in) throws IOException {
        this.checkpoint = in.readVLong();
        this.position = in.readBoolean() ? new TransformIndexerPosition(in) : null;
        this.checkpointProgress = in.readBoolean() ? new TransformProgress(in) : null;
        this.timestampMillis = in.readLong();
        this.timeUpperBoundMillis = in.readLong();
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public TransformIndexerPosition getPosition() {
        return this.position;
    }

    public TransformProgress getCheckpointProgress() {
        return this.checkpointProgress;
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public long getTimeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.CHECKPOINT.getPreferredName(), this.checkpoint);
        if (this.position != null) {
            builder.field(TransformField.POSITION.getPreferredName(), (ToXContent)this.position);
        }
        if (this.checkpointProgress != null) {
            builder.field(TransformField.CHECKPOINT_PROGRESS.getPreferredName(), (ToXContent)this.checkpointProgress);
        }
        if (this.timestampMillis > 0L) {
            builder.timeField(TransformField.TIMESTAMP_MILLIS.getPreferredName(), TransformField.TIMESTAMP.getPreferredName(), this.timestampMillis);
        }
        if (this.timeUpperBoundMillis > 0L) {
            builder.timeField(TransformField.TIME_UPPER_BOUND_MILLIS.getPreferredName(), TransformField.TIME_UPPER_BOUND.getPreferredName(), this.timeUpperBoundMillis);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.checkpoint);
        if (this.position != null) {
            out.writeBoolean(true);
            this.position.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.checkpointProgress != null) {
            out.writeBoolean(true);
            this.checkpointProgress.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.timestampMillis);
        out.writeLong(this.timeUpperBoundMillis);
    }

    public int hashCode() {
        return Objects.hash(this.checkpoint, this.position, this.checkpointProgress, this.timestampMillis, this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformCheckpointStats that = (TransformCheckpointStats)other;
        return this.checkpoint == that.checkpoint && Objects.equals(this.position, that.position) && Objects.equals(this.checkpointProgress, that.checkpointProgress) && this.timestampMillis == that.timestampMillis && this.timeUpperBoundMillis == that.timeUpperBoundMillis;
    }
}

