/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public abstract class BaseUpdateApiKeyRequest
extends ActionRequest {
    @Nullable
    protected final List<RoleDescriptor> roleDescriptors;
    @Nullable
    protected final Map<String, Object> metadata;

    public BaseUpdateApiKeyRequest(@Nullable List<RoleDescriptor> roleDescriptors, @Nullable Map<String, Object> metadata) {
        this.roleDescriptors = roleDescriptors;
        this.metadata = metadata;
    }

    public BaseUpdateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.roleDescriptors = in.readOptionalCollectionAsList(RoleDescriptor::new);
        this.metadata = in.readMap();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public abstract ApiKey.Type getType();

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.metadata != null && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError((String)"API key metadata keys may not start with [_]", validationException);
        }
        if (this.roleDescriptors != null) {
            for (RoleDescriptor roleDescriptor : this.roleDescriptors) {
                validationException = RoleDescriptorRequestValidator.validate(roleDescriptor, validationException);
            }
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalCollection(this.roleDescriptors);
        out.writeGenericMap(this.metadata);
    }
}

