/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;

@Deprecated
public record LegacyTextEmbeddingResults(List<Embedding> embeddings) implements InferenceResults
{
    public static final String NAME = "text_embedding_results";
    public static final String TEXT_EMBEDDING = TaskType.TEXT_EMBEDDING.toString();

    public LegacyTextEmbeddingResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TEXT_EMBEDDING);
        for (Embedding embedding : this.embeddings) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public String getResultsField() {
        return TEXT_EMBEDDING;
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getResultsField(), this.embeddings.stream().map(Embedding::asMap).collect(Collectors.toList()));
        return map;
    }

    public Map<String, Object> asMap(String outputField) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(outputField, this.embeddings.stream().map(Embedding::asMap).collect(Collectors.toList()));
        return map;
    }

    public Object predictedValue() {
        throw new UnsupportedOperationException("[text_embedding_results] does not support a single predicted value");
    }

    public TextEmbeddingResults transformToTextEmbeddingResults() {
        return new TextEmbeddingResults(this);
    }

    public record Embedding(List<Float> values) implements Writeable,
    ToXContentObject
    {
        public static final String EMBEDDING = "embedding";

        public Embedding(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableList(StreamInput::readFloat));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.values, StreamOutput::writeFloat);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (Float value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public Map<String, Object> asMap() {
            return Map.of(EMBEDDING, this.values);
        }
    }
}

