/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackBuild;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;

public class TransportXPackInfoAction
extends HandledTransportAction<XPackInfoRequest, XPackInfoResponse> {
    private final LicenseService licenseService;
    private final NodeClient client;
    private final List<XPackInfoFeatureAction> infoActions;

    @Inject
    public TransportXPackInfoAction(TransportService transportService, ActionFilters actionFilters, LicenseService licenseService, NodeClient client) {
        super("cluster:monitor/xpack/info", transportService, actionFilters, XPackInfoRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseService = licenseService;
        this.client = client;
        this.infoActions = this.infoActions();
    }

    protected List<XPackInfoFeatureAction> infoActions() {
        return XPackInfoFeatureAction.ALL;
    }

    protected void doExecute(Task task, XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        License license;
        XPackInfoResponse.BuildInfo buildInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.BUILD)) {
            buildInfo = new XPackInfoResponse.BuildInfo(XPackBuild.CURRENT.shortHash(), XPackBuild.CURRENT.date());
        }
        XPackInfoResponse.LicenseInfo licenseInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.LICENSE) && (license = this.licenseService.getLicense()) != null) {
            licenseInfo = new XPackInfoResponse.LicenseInfo(license.uid(), license.type(), license.operationMode().description(), LicenseUtils.status(license), LicenseUtils.getExpiryDate(license));
        }
        XPackInfoResponse.FeatureSetsInfo featureSetsInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.FEATURES)) {
            HashSet<XPackInfoResponse.FeatureSetsInfo.FeatureSet> featureSets = new HashSet<XPackInfoResponse.FeatureSetsInfo.FeatureSet>();
            for (XPackInfoFeatureAction infoAction : this.infoActions) {
                this.client.executeLocally((ActionType)infoAction, (ActionRequest)request, listener.delegateFailureAndWrap((l, response) -> featureSets.add(response.getInfo())));
            }
            featureSetsInfo = new XPackInfoResponse.FeatureSetsInfo(featureSets);
        }
        listener.onResponse((Object)new XPackInfoResponse(buildInfo, licenseInfo, featureSetsInfo));
    }
}

