/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.upgrade.UpgradeField;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.watch.WatchParser;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class WatcherService {
    private static final String LIFECYCLE_THREADPOOL_NAME = "watcher-lifecycle";
    private static final Logger logger = LogManager.getLogger(WatcherService.class);
    private final TriggerService triggerService;
    private final TriggeredWatchStore triggeredWatchStore;
    private final ExecutionService executionService;
    private final TimeValue scrollTimeout;
    private final int scrollSize;
    private final WatchParser parser;
    private final Client client;
    private final TimeValue defaultSearchTimeout;
    private final AtomicLong processedClusterStateVersion = new AtomicLong(0L);
    private final ExecutorService executor;

    WatcherService(Settings settings, TriggerService triggerService, TriggeredWatchStore triggeredWatchStore, ExecutionService executionService, WatchParser parser, Client client, ExecutorService executor) {
        this.triggerService = triggerService;
        this.triggeredWatchStore = triggeredWatchStore;
        this.executionService = executionService;
        this.scrollTimeout = settings.getAsTime("xpack.watcher.watch.scroll.timeout", TimeValue.timeValueSeconds((long)30L));
        this.scrollSize = settings.getAsInt("xpack.watcher.watch.scroll.size", Integer.valueOf(100));
        this.defaultSearchTimeout = settings.getAsTime("xpack.watcher.internal.ops.search.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.parser = parser;
        this.client = ClientHelper.clientWithOrigin((Client)client, (String)"watcher");
        this.executor = executor;
    }

    WatcherService(Settings settings, TriggerService triggerService, TriggeredWatchStore triggeredWatchStore, ExecutionService executionService, WatchParser parser, Client client) {
        this(settings, triggerService, triggeredWatchStore, executionService, parser, client, (ExecutorService)EsExecutors.newFixed((String)LIFECYCLE_THREADPOOL_NAME, (int)1, (int)1000, (ThreadFactory)EsExecutors.daemonThreadFactory((Settings)settings, (String)LIFECYCLE_THREADPOOL_NAME), (ThreadContext)client.threadPool().getThreadContext(), (EsExecutors.TaskTrackingConfig)EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
    }

    public boolean validate(ClusterState state) {
        boolean isIndexInternalFormatTriggeredWatchIndex;
        IndexMetadata watcherIndexMetadata = WatchStoreUtils.getConcreteIndex(".watches", state.metadata());
        IndexMetadata triggeredWatchesIndexMetadata = WatchStoreUtils.getConcreteIndex(".triggered_watches", state.metadata());
        boolean isIndexInternalFormatWatchIndex = watcherIndexMetadata == null || UpgradeField.checkInternalIndexFormat((IndexMetadata)watcherIndexMetadata);
        boolean bl = isIndexInternalFormatTriggeredWatchIndex = triggeredWatchesIndexMetadata == null || UpgradeField.checkInternalIndexFormat((IndexMetadata)triggeredWatchesIndexMetadata);
        if (!isIndexInternalFormatTriggeredWatchIndex || !isIndexInternalFormatWatchIndex) {
            logger.warn("not starting watcher, upgrade API run required: .watches[{}], .triggered_watches[{}]", (Object)isIndexInternalFormatWatchIndex, (Object)isIndexInternalFormatTriggeredWatchIndex);
            return false;
        }
        try {
            boolean storesValid;
            boolean bl2 = storesValid = TriggeredWatchStore.validate(state) && HistoryStore.validate(state);
            if (!storesValid) {
                return false;
            }
            return watcherIndexMetadata == null || watcherIndexMetadata.getState() == IndexMetadata.State.OPEN && state.routingTable().index(watcherIndexMetadata.getIndex()).allPrimaryShardsActive();
        }
        catch (IllegalStateException e) {
            logger.warn("Validation error: cannot start watcher", (Throwable)e);
            return false;
        }
    }

    public void stop(String reason, Runnable stoppedListener) {
        assert (stoppedListener != null);
        logger.info("stopping watch service, reason [{}]", (Object)reason);
        this.executionService.pause(stoppedListener);
        this.triggerService.pauseExecution();
    }

    void shutDown(Runnable stoppedListener) {
        assert (stoppedListener != null);
        logger.info("stopping watch service, reason [shutdown initiated]");
        this.executionService.pause(stoppedListener);
        this.triggerService.stop();
        this.stopExecutor();
    }

    void stopExecutor() {
        ThreadPool.terminate((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    void reload(ClusterState state, String reason) {
        boolean hasValidWatcherTemplates = WatcherIndexTemplateRegistry.validate(state);
        if (!hasValidWatcherTemplates) {
            logger.warn("missing watcher index templates");
        }
        this.processedClusterStateVersion.set(state.getVersion());
        this.triggerService.pauseExecution();
        int cancelledTaskCount = this.executionService.clearExecutionsAndQueue(() -> {});
        logger.info("reloading watcher, reason [{}], cancelled [{}] queued tasks", (Object)reason, (Object)cancelledTaskCount);
        this.executor.execute((Runnable)WatcherService.wrapWatcherService(() -> this.reloadInner(state, reason, false), e -> logger.error("error reloading watcher", (Throwable)e)));
    }

    public void start(ClusterState state, Runnable postWatchesLoadedCallback, Consumer<Exception> exceptionConsumer) {
        this.executionService.unPause();
        this.processedClusterStateVersion.set(state.getVersion());
        this.executor.execute((Runnable)WatcherService.wrapWatcherService(() -> {
            if (this.reloadInner(state, "starting", true)) {
                postWatchesLoadedCallback.run();
            }
        }, e -> {
            logger.error("error starting watcher", (Throwable)e);
            exceptionConsumer.accept((Exception)e);
        }));
    }

    private synchronized boolean reloadInner(ClusterState state, String reason, boolean loadTriggeredWatches) {
        if (this.processedClusterStateVersion.get() != state.getVersion()) {
            logger.debug("watch service has not been reloaded for state [{}], another reload for state [{}] in progress", (Object)state.getVersion(), (Object)this.processedClusterStateVersion.get());
            return false;
        }
        Collection<Watch> watches = this.loadWatches(state);
        Collection<Object> triggeredWatches = Collections.emptyList();
        if (loadTriggeredWatches) {
            triggeredWatches = this.triggeredWatchStore.findTriggeredWatches(watches, state);
        }
        if (this.processedClusterStateVersion.get() == state.getVersion()) {
            this.executionService.unPause();
            this.triggerService.start(watches);
            if (!triggeredWatches.isEmpty()) {
                this.executionService.executeTriggeredWatches(triggeredWatches);
            }
            logger.debug("watch service has been reloaded, reason [{}]", (Object)reason);
            return true;
        }
        logger.debug("watch service has not been reloaded for state [{}], another reload for state [{}] in progress", (Object)state.getVersion(), (Object)this.processedClusterStateVersion.get());
        return false;
    }

    public void pauseExecution(String reason) {
        this.triggerService.pauseExecution();
        int cancelledTaskCount = this.executionService.pause(() -> {});
        logger.info("paused watch execution, reason [{}], cancelled [{}] queued tasks", (Object)reason, (Object)cancelledTaskCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Watch> loadWatches(ClusterState clusterState) {
        IndexMetadata indexMetadata = WatchStoreUtils.getConcreteIndex(".watches", clusterState.metadata());
        if (indexMetadata == null) {
            return Collections.emptyList();
        }
        SearchResponse response = null;
        ArrayList<Watch> watches = new ArrayList<Watch>();
        try {
            this.refreshWatches(indexMetadata);
            String watchIndexName = indexMetadata.getIndex().getName();
            RoutingNode routingNode = clusterState.getRoutingNodes().node(clusterState.nodes().getLocalNodeId());
            if (routingNode == null) {
                List<Watch> list = Collections.emptyList();
                return list;
            }
            List localShards = routingNode.shardsWithState(watchIndexName, new ShardRoutingState[]{ShardRoutingState.RELOCATING, ShardRoutingState.STARTED}).toList();
            List watchIndexShardRoutings = clusterState.getRoutingTable().allShards(watchIndexName);
            SearchRequest searchRequest = new SearchRequest(new String[]{".watches"}).scroll(this.scrollTimeout).preference(Preference.ONLY_LOCAL.toString()).source(new SearchSourceBuilder().size(this.scrollSize).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).seqNoAndPrimaryTerm(Boolean.valueOf(true)));
            response = (SearchResponse)this.client.search(searchRequest).actionGet(this.defaultSearchTimeout);
            if (response.getTotalShards() != response.getSuccessfulShards()) {
                throw new ElasticsearchException("Partial response while loading watches", new Object[0]);
            }
            if (response.getHits().getTotalHits().value == 0L) {
                List<Watch> list = Collections.emptyList();
                return list;
            }
            Map sortedShards = Maps.newMapWithExpectedSize((int)localShards.size());
            for (ShardRouting localShardRouting : localShards) {
                List<String> sortedAllocationIds = watchIndexShardRoutings.stream().filter(sr -> localShardRouting.getId() == sr.getId()).map(ShardRouting::allocationId).filter(Objects::nonNull).map(AllocationId::getId).filter(Objects::nonNull).sorted().toList();
                sortedShards.put(localShardRouting.getId(), sortedAllocationIds);
            }
            while (response.getHits().getHits().length != 0) {
                for (SearchHit hit : response.getHits()) {
                    Optional<ShardRouting> correspondingShardOptional = localShards.stream().filter(sr -> sr.shardId().equals((Object)hit.getShard().getShardId())).findFirst();
                    if (!correspondingShardOptional.isPresent()) continue;
                    ShardRouting correspondingShard = correspondingShardOptional.get();
                    List shardAllocationIds = (List)sortedShards.get(hit.getShard().getShardId().id());
                    int bucket = shardAllocationIds.indexOf(correspondingShard.allocationId().getId());
                    String id = hit.getId();
                    if (!WatcherService.parseWatchOnThisNode(hit.getId(), shardAllocationIds.size(), bucket)) continue;
                    try {
                        Watch watch = this.parser.parse(id, true, hit.getSourceRef(), XContentType.JSON, hit.getSeqNo(), hit.getPrimaryTerm());
                        if (!watch.status().state().isActive()) continue;
                        watches.add(watch);
                    }
                    catch (Exception e) {
                        logger.error(() -> "couldn't load watch [" + id + "], ignoring it...", (Throwable)e);
                    }
                }
                SearchScrollRequest request = new SearchScrollRequest(response.getScrollId());
                request.scroll(this.scrollTimeout);
                response = (SearchResponse)this.client.searchScroll(request).actionGet(this.defaultSearchTimeout);
            }
        }
        finally {
            if (response != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                this.client.clearScroll(clearScrollRequest).actionGet(this.scrollTimeout);
            }
        }
        logger.debug("Loaded [{}] watches for execution", (Object)watches.size());
        return watches;
    }

    void refreshWatches(IndexMetadata indexMetadata) {
        RefreshResponse refreshResponse = (RefreshResponse)this.client.admin().indices().refresh(new RefreshRequest(new String[]{".watches"})).actionGet(TimeValue.timeValueSeconds((long)5L));
        if (refreshResponse.getSuccessfulShards() < indexMetadata.getNumberOfShards()) {
            throw Exceptions.illegalState((String)"not all required shards have been refreshed", (Object[])new Object[0]);
        }
    }

    private static boolean parseWatchOnThisNode(String id, int totalShardCount, int index) {
        int hash = Murmur3HashFunction.hash((String)id);
        int shardIndex = Math.floorMod(hash, totalShardCount);
        return shardIndex == index;
    }

    private static AbstractRunnable wrapWatcherService(final Runnable run, final Consumer<Exception> exceptionConsumer) {
        return new AbstractRunnable(){

            public void onFailure(Exception e) {
                exceptionConsumer.accept(e);
            }

            protected void doRun() throws Exception {
                run.run();
            }
        };
    }
}

