/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformHealth;
import org.elasticsearch.xpack.core.transform.transforms.TransformHealthIssue;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public final class TransformHealthChecker {
    static int RED_STATUS_FAILURE_COUNT_BOUNDARY = 5;

    public static TransformHealth checkUnassignedTransform(String transformId, ClusterState clusterState, @Nullable AuthorizationState authState) {
        PersistentTasksCustomMetadata.Assignment assignment = TransformNodes.getAssignment(transformId, clusterState);
        ArrayList<TransformHealthIssue> issues = new ArrayList<TransformHealthIssue>(2);
        issues.add(IssueType.ASSIGNMENT_FAILED.newIssue(assignment.getExplanation(), 1, null));
        if (!AuthorizationState.isNullOrGreen((AuthorizationState)authState)) {
            issues.add(IssueType.PRIVILEGES_CHECK_FAILED.newIssue(authState.getLastAuthError(), 1, null));
        }
        return new TransformHealth(HealthStatus.RED, Collections.unmodifiableList(issues));
    }

    public static TransformHealth checkTransform(@Nullable AuthorizationState authState) {
        if (AuthorizationState.isNullOrGreen((AuthorizationState)authState)) {
            return TransformHealth.GREEN;
        }
        return new TransformHealth(authState.getStatus(), List.of(IssueType.PRIVILEGES_CHECK_FAILED.newIssue(authState.getLastAuthError(), 1, null)));
    }

    public static TransformHealth checkTransform(TransformTask transformTask) {
        return TransformHealthChecker.checkTransform(transformTask, null);
    }

    public static TransformHealth checkTransform(TransformTask transformTask, @Nullable AuthorizationState authState) {
        if (!TransformTaskState.FAILED.equals((Object)transformTask.getState().getTaskState()) && transformTask.getContext().getFailureCount() == 0 && transformTask.getContext().getStatePersistenceFailureCount() == 0 && AuthorizationState.isNullOrGreen((AuthorizationState)authState)) {
            return TransformHealth.GREEN;
        }
        TransformContext transformContext = transformTask.getContext();
        ArrayList<TransformHealthIssue> issues = new ArrayList<TransformHealthIssue>();
        HealthStatus maxStatus = HealthStatus.GREEN;
        if (!AuthorizationState.isNullOrGreen((AuthorizationState)authState)) {
            maxStatus = authState.getStatus();
            issues.add(IssueType.PRIVILEGES_CHECK_FAILED.newIssue(authState.getLastAuthError(), 1, null));
        }
        if (TransformTaskState.FAILED.equals((Object)transformTask.getState().getTaskState())) {
            maxStatus = HealthStatus.RED;
            issues.add(IssueType.TRANSFORM_TASK_FAILED.newIssue(transformTask.getState().getReason(), 1, transformContext.getStateFailureTime()));
        }
        if (transformContext.getFailureCount() != 0) {
            String lastFailureMessage;
            Throwable lastFailure = transformContext.getLastFailure();
            if (lastFailure instanceof ElasticsearchException) {
                ElasticsearchException elasticsearchException = (ElasticsearchException)lastFailure;
                v0 = elasticsearchException.getDetailedMessage();
            } else {
                v0 = lastFailureMessage = lastFailure.getMessage();
            }
            if (!HealthStatus.RED.equals((Object)maxStatus)) {
                maxStatus = transformContext.getFailureCount() > RED_STATUS_FAILURE_COUNT_BOUNDARY ? HealthStatus.RED : HealthStatus.YELLOW;
            }
            issues.add(IssueType.TRANSFORM_INDEXER_FAILED.newIssue(lastFailureMessage, transformContext.getFailureCount(), transformContext.getLastFailureStartTime()));
        }
        if (transformContext.getStatePersistenceFailureCount() != 0) {
            if (!HealthStatus.RED.equals((Object)maxStatus)) {
                maxStatus = transformContext.getStatePersistenceFailureCount() > RED_STATUS_FAILURE_COUNT_BOUNDARY ? HealthStatus.RED : HealthStatus.YELLOW;
            }
            issues.add(IssueType.TRANSFORM_INTERNAL_STATE_UPDATE_FAILED.newIssue(transformContext.getLastStatePersistenceFailure().getMessage(), transformContext.getStatePersistenceFailureCount(), transformContext.getLastStatePersistenceFailureStartTime()));
        }
        return new TransformHealth(maxStatus, issues);
    }

    private TransformHealthChecker() {
    }

    public static enum IssueType {
        ASSIGNMENT_FAILED("Failed to assign transform to a node"),
        PRIVILEGES_CHECK_FAILED("Privileges check failed"),
        TRANSFORM_TASK_FAILED("Transform task state is [failed]"),
        TRANSFORM_INDEXER_FAILED("Transform indexer failed"),
        TRANSFORM_INTERNAL_STATE_UPDATE_FAILED("Task encountered failures updating internal state");

        private final String issue;

        private IssueType(String issue) {
            this.issue = issue;
        }

        public TransformHealthIssue newIssue(@Nullable String details, int count, @Nullable Instant firstOccurrence) {
            String type = this.name().toLowerCase(Locale.ROOT);
            return new TransformHealthIssue(type, this.issue, details, count, firstOccurrence);
        }
    }
}

