/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformStats;
import org.elasticsearch.xpack.transform.Transform;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCatTransformAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_cat/transforms"), new RestHandler.Route(RestRequest.Method.GET, "_cat/transforms/{transform_id}"));
    }

    public String getName() {
        return "cat_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(RestRequest restRequest, final NodeClient client) {
        String id = restRequest.param("transform_id");
        if (Strings.isNullOrEmpty((String)id)) {
            id = "_all";
        }
        GetTransformAction.Request request = new GetTransformAction.Request(id);
        request.setAllowNoResources(restRequest.paramAsBoolean(TransformField.ALLOW_NO_MATCH.getPreferredName(), true));
        final GetTransformStatsAction.Request statsRequest = new GetTransformStatsAction.Request(id, null);
        statsRequest.setAllowNoMatch(restRequest.paramAsBoolean(TransformField.ALLOW_NO_MATCH.getPreferredName(), true));
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            PageParams pageParams = new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100));
            request.setPageParams(pageParams);
            statsRequest.setPageParams(pageParams);
        }
        return channel -> client.execute((ActionType)GetTransformAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestActionListener<GetTransformAction.Response>(channel){

            public void processResponse(final GetTransformAction.Response response) {
                client.execute((ActionType)GetTransformStatsAction.INSTANCE, (ActionRequest)statsRequest, (ActionListener)new RestResponseListener<GetTransformStatsAction.Response>(this.channel){

                    public RestResponse buildResponse(GetTransformStatsAction.Response statsResponse) throws Exception {
                        return RestTable.buildResponse((Table)RestCatTransformAction.buildTable(response, statsResponse), (RestChannel)this.channel);
                    }
                });
            }
        });
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/transforms\n");
        sb.append("/_cat/transforms/{transform_id}\n");
    }

    protected Table getTableWithHeader(RestRequest unused) {
        return RestCatTransformAction.getTableWithHeader();
    }

    private static Table getTableWithHeader() {
        return new Table().startHeaders().addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the id").build()).addCell((Object)"state", TableColumnAttributeBuilder.builder((String)"transform state").setAliases(new String[]{"s"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build()).addCell((Object)"checkpoint", TableColumnAttributeBuilder.builder((String)"checkpoint").setAliases(new String[]{"c"}).build()).addCell((Object)"documents_processed", TableColumnAttributeBuilder.builder((String)"the number of documents read from source indices and processed").setAliases(new String[]{"docp", "documentsProcessed"}).build()).addCell((Object)"checkpoint_progress", TableColumnAttributeBuilder.builder((String)"progress of the checkpoint").setAliases(new String[]{"cp", "checkpointProgress"}).build()).addCell((Object)"last_search_time", TableColumnAttributeBuilder.builder((String)"last time transform searched for updates").setAliases(new String[]{"lst", "lastSearchTime"}).build()).addCell((Object)"changes_last_detection_time", TableColumnAttributeBuilder.builder((String)"changes last detected time").setAliases(new String[]{"cldt"}).build()).addCell((Object)"create_time", TableColumnAttributeBuilder.builder((String)"transform creation time", (boolean)false).setAliases(new String[]{"ct", "createTime"}).build()).addCell((Object)"version", TableColumnAttributeBuilder.builder((String)"the version of Elasticsearch when the transform was created", (boolean)false).setAliases(new String[]{"v"}).build()).addCell((Object)"source_index", TableColumnAttributeBuilder.builder((String)"source index", (boolean)false).setAliases(new String[]{"si", "sourceIndex"}).build()).addCell((Object)"dest_index", TableColumnAttributeBuilder.builder((String)"destination index", (boolean)false).setAliases(new String[]{"di", "destIndex"}).build()).addCell((Object)"pipeline", TableColumnAttributeBuilder.builder((String)"transform pipeline", (boolean)false).setAliases(new String[]{"p"}).build()).addCell((Object)"description", TableColumnAttributeBuilder.builder((String)"description", (boolean)false).setAliases(new String[]{"d"}).build()).addCell((Object)"transform_type", TableColumnAttributeBuilder.builder((String)"batch or continuous transform", (boolean)false).setAliases(new String[]{"tt"}).build()).addCell((Object)"frequency", TableColumnAttributeBuilder.builder((String)"frequency of transform", (boolean)false).setAliases(new String[]{"f"}).build()).addCell((Object)"max_page_search_size", TableColumnAttributeBuilder.builder((String)"max page search size", (boolean)false).setAliases(new String[]{"mpsz"}).build()).addCell((Object)"docs_per_second", TableColumnAttributeBuilder.builder((String)"docs per second", (boolean)false).setAliases(new String[]{"dps"}).build()).addCell((Object)"reason", TableColumnAttributeBuilder.builder((String)"reason for the current state", (boolean)false).setAliases(new String[]{"r", "reason"}).build()).addCell((Object)"search_total", TableColumnAttributeBuilder.builder((String)"total number of search phases", (boolean)false).setAliases(new String[]{"st"}).build()).addCell((Object)"search_failure", TableColumnAttributeBuilder.builder((String)"total number of search failures", (boolean)false).setAliases(new String[]{"sf"}).build()).addCell((Object)"search_time", TableColumnAttributeBuilder.builder((String)"total search time", (boolean)false).setAliases(new String[]{"stime"}).build()).addCell((Object)"index_total", TableColumnAttributeBuilder.builder((String)"total number of index phases done by the transform", (boolean)false).setAliases(new String[]{"it"}).build()).addCell((Object)"index_failure", TableColumnAttributeBuilder.builder((String)"total number of index failures", (boolean)false).setAliases(new String[]{"if"}).build()).addCell((Object)"index_time", TableColumnAttributeBuilder.builder((String)"total time spent indexing documents", (boolean)false).setAliases(new String[]{"itime"}).build()).addCell((Object)"documents_indexed", TableColumnAttributeBuilder.builder((String)"the number of documents written to the destination index", (boolean)false).setAliases(new String[]{"doci"}).build()).addCell((Object)"delete_time", TableColumnAttributeBuilder.builder((String)"total time spent deleting documents", (boolean)false).setAliases(new String[]{"dtime"}).build()).addCell((Object)"documents_deleted", TableColumnAttributeBuilder.builder((String)"the number of documents deleted from the destination index", (boolean)false).setAliases(new String[]{"docd"}).build()).addCell((Object)"trigger_count", TableColumnAttributeBuilder.builder((String)"the number of times the transform has been triggered", (boolean)false).setAliases(new String[]{"tc"}).build()).addCell((Object)"pages_processed", TableColumnAttributeBuilder.builder((String)"the number of pages processed", (boolean)false).setAliases(new String[]{"pp"}).build()).addCell((Object)"processing_time", TableColumnAttributeBuilder.builder((String)"the total time spent processing documents", (boolean)false).setAliases(new String[]{"pt"}).build()).addCell((Object)"checkpoint_duration_time_exp_avg", TableColumnAttributeBuilder.builder((String)"exponential average checkpoint processing time (milliseconds)", (boolean)false).setAliases(new String[]{"cdtea", "checkpointTimeExpAvg"}).build()).addCell((Object)"indexed_documents_exp_avg", TableColumnAttributeBuilder.builder((String)"exponential average number of documents indexed", (boolean)false).setAliases(new String[]{"idea"}).build()).addCell((Object)"processed_documents_exp_avg", TableColumnAttributeBuilder.builder((String)"exponential average number of documents processed", (boolean)false).setAliases(new String[]{"pdea"}).build()).endHeaders();
    }

    private static Table buildTable(GetTransformAction.Response response, GetTransformStatsAction.Response statsResponse) {
        Table table = RestCatTransformAction.getTableWithHeader();
        Map statsById = statsResponse.getTransformsStats().stream().collect(Collectors.toMap(TransformStats::getId, Function.identity()));
        response.getTransformConfigurations().forEach(config -> {
            Integer maxPageSearchSize;
            TransformStats stats = (TransformStats)statsById.get(config.getId());
            TransformCheckpointingInfo checkpointingInfo = null;
            TransformIndexerStats transformIndexerStats = null;
            if (stats != null) {
                checkpointingInfo = stats.getCheckpointingInfo();
                transformIndexerStats = stats.getIndexerStats();
            }
            Integer n = config.getSettings() == null || config.getSettings().getMaxPageSearchSize() == null ? (config.getPivotConfig() == null || config.getPivotConfig().getMaxPageSearchSize() == null ? Transform.DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE : config.getPivotConfig().getMaxPageSearchSize()) : (maxPageSearchSize = config.getSettings().getMaxPageSearchSize());
            Double progress = checkpointingInfo == null ? null : (checkpointingInfo.getNext().getCheckpointProgress() == null ? null : checkpointingInfo.getNext().getCheckpointProgress().getPercentComplete());
            table.startRow().addCell((Object)config.getId()).addCell(stats == null ? null : stats.getState().toString()).addCell(checkpointingInfo == null ? null : Long.valueOf(checkpointingInfo.getLast().getCheckpoint())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getNumDocuments())).addCell(progress == null ? null : String.format(Locale.ROOT, "%.2f", progress)).addCell(checkpointingInfo == null ? null : (checkpointingInfo.getLastSearchTime() == null ? null : Date.from(checkpointingInfo.getLastSearchTime()))).addCell(checkpointingInfo == null ? null : (checkpointingInfo.getChangesLastDetectedAt() == null ? null : Date.from(checkpointingInfo.getChangesLastDetectedAt()))).addCell(config.getCreateTime() == null ? null : Date.from(config.getCreateTime())).addCell((Object)config.getVersion()).addCell((Object)String.join((CharSequence)",", config.getSource().getIndex())).addCell((Object)config.getDestination().getIndex()).addCell((Object)config.getDestination().getPipeline()).addCell((Object)config.getDescription()).addCell((Object)(config.getSyncConfig() == null ? "batch" : "continuous")).addCell((Object)(config.getFrequency() == null ? Transform.DEFAULT_TRANSFORM_FREQUENCY : config.getFrequency())).addCell((Object)maxPageSearchSize).addCell(config.getSettings() == null || config.getSettings().getDocsPerSecond() == null ? "-" : config.getSettings().getDocsPerSecond()).addCell((Object)(stats == null ? null : stats.getReason())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getSearchTotal())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getSearchFailures())).addCell(transformIndexerStats == null ? null : TimeValue.timeValueMillis((long)transformIndexerStats.getSearchTime())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getIndexTotal())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getIndexFailures())).addCell(transformIndexerStats == null ? null : TimeValue.timeValueMillis((long)transformIndexerStats.getIndexTime())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getOutputDocuments())).addCell(transformIndexerStats == null ? null : TimeValue.timeValueMillis((long)transformIndexerStats.getDeleteTime())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getNumDeletedDocuments())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getNumInvocations())).addCell(transformIndexerStats == null ? null : Long.valueOf(transformIndexerStats.getNumPages())).addCell(transformIndexerStats == null ? null : TimeValue.timeValueMillis((long)transformIndexerStats.getProcessingTime())).addCell(transformIndexerStats == null ? null : String.format(Locale.ROOT, "%.2f", transformIndexerStats.getExpAvgCheckpointDurationMs())).addCell(transformIndexerStats == null ? null : String.format(Locale.ROOT, "%.2f", transformIndexerStats.getExpAvgDocumentsIndexed())).addCell(transformIndexerStats == null ? null : String.format(Locale.ROOT, "%.2f", transformIndexerStats.getExpAvgDocumentsProcessed())).endRow();
        });
        return table;
    }
}

