/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.RestDeleteByQueryAction;
import org.elasticsearch.reindex.RestReindexAction;
import org.elasticsearch.reindex.RestRethrottleAction;
import org.elasticsearch.reindex.RestUpdateByQueryAction;
import org.elasticsearch.reindex.TransportDeleteByQueryAction;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.reindex.TransportRethrottleAction;
import org.elasticsearch.reindex.TransportUpdateByQueryAction;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.tasks.Task;

public class ReindexPlugin
extends Plugin
implements ActionPlugin {
    public static final String NAME = "reindex";
    public static final ActionType<ListTasksResponse> RETHROTTLE_ACTION = new ActionType("cluster:admin/reindex/rethrottle", ListTasksResponse::new);

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ReindexAction.INSTANCE, TransportReindexAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateByQueryAction.INSTANCE, TransportUpdateByQueryAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteByQueryAction.INSTANCE, TransportDeleteByQueryAction.class), new ActionPlugin.ActionHandler(RETHROTTLE_ACTION, TransportRethrottleAction.class));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(Task.Status.class, "bulk-by-scroll", BulkByScrollTask.Status::new));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestReindexAction(), new RestUpdateByQueryAction(), new RestDeleteByQueryAction(), new RestRethrottleAction(nodesInCluster)});
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        return Collections.singletonList(new ReindexSslConfig(services.environment().settings(), services.environment(), services.resourceWatcherService()));
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(TransportReindexAction.REMOTE_CLUSTER_WHITELIST);
        settings.addAll(ReindexSslConfig.getSettings());
        return settings;
    }
}

