/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.multiterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.multiterms.InternalMultiTerms;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregationBuilder;

class MultiTermsAggregator
extends DeferableBucketAggregator {
    protected final List<DocValueFormat> formats;
    protected final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    protected final BucketOrder order;
    protected final Comparator<InternalMultiTerms.Bucket> partiallyBuiltBucketComparator;
    protected final Set<Aggregator> aggsUsedForSorting;
    protected final Aggregator.SubAggCollectionMode collectMode;
    private final List<TermValuesSource> values;
    private final boolean showTermDocCountError;
    private final boolean needsScore;
    private final List<InternalMultiTerms.KeyConverter> keyConverters;
    private final BytesKeyedBucketOrds bucketOrds;

    protected MultiTermsAggregator(String name, AggregatorFactories factories, AggregationContext context, Aggregator parent, List<ValuesSourceConfig> configs, List<DocValueFormat> formats, boolean showTermDocCountError, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = order;
        this.partiallyBuiltBucketComparator = order == null ? null : order.partiallyBuiltBucketComparator(b -> b.bucketOrd, (Aggregator)this);
        this.formats = formats;
        this.showTermDocCountError = showTermDocCountError;
        this.collectMode = this.subAggsNeedScore() && TermsAggregator.descendsFromNestedAggregator((Aggregator)parent) ? Aggregator.SubAggCollectionMode.DEPTH_FIRST : collectMode;
        this.aggsUsedForSorting = TermsAggregator.aggsUsedForSorting((Aggregator)this, (BucketOrder)order);
        this.needsScore = configs.stream().anyMatch(c -> c.getValuesSource().needsScores());
        this.values = configs.stream().map(c -> ((MultiTermsAggregationBuilder.MultiTermValuesSupplier)context.getValuesSourceRegistry().getAggregator(MultiTermsAggregationBuilder.REGISTRY_KEY, c)).build((ValuesSourceConfig)c)).collect(Collectors.toList());
        this.keyConverters = this.values.stream().map(TermValuesSource::keyConverter).collect(Collectors.toList());
        this.bucketOrds = BytesKeyedBucketOrds.build((BigArrays)context.bigArrays(), (CardinalityUpperBound)cardinality);
    }

    private boolean subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return true;
        }
        return false;
    }

    public ScoreMode scoreMode() {
        if (this.needsScore) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return this.collectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && !this.aggsUsedForSorting.contains(aggregator);
    }

    List<TermValues> termValuesList(LeafReaderContext ctx) throws IOException {
        ArrayList<TermValues> termValuesList = new ArrayList<TermValues>();
        for (TermValuesSource termValuesSource : this.values) {
            termValuesList.add(termValuesSource.getValues(ctx));
        }
        return termValuesList;
    }

    static List<List<Object>> docTerms(List<TermValues> termValuesList, int doc) throws IOException {
        ArrayList<List<Object>> terms = new ArrayList<List<Object>>();
        for (TermValues termValues : termValuesList) {
            List<Object> collectValues = termValues.collectValues(doc);
            if (collectValues == null) {
                return null;
            }
            terms.add(collectValues);
        }
        return terms;
    }

    static BytesRef packKey(List<Object> terms) {
        BytesRef bytesRef;
        BytesStreamOutput output = new BytesStreamOutput();
        try {
            output.writeCollection(terms, StreamOutput::writeGenericValue);
            bytesRef = output.bytes().toBytesRef();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptionsHelper.convertToRuntime((Exception)ex);
            }
        }
        output.close();
        return bytesRef;
    }

    static List<Object> unpackTerms(BytesRef termsBytes) {
        List list;
        block8: {
            StreamInput input = new BytesArray(termsBytes).streamInput();
            try {
                list = input.readCollectionAsList(StreamInput::readGenericValue);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToRuntime((Exception)ex);
                }
            }
            input.close();
        }
        return list;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final List<TermValues> termValuesList = this.termValuesList(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, this.values){

            public void collect(final int doc, final long owningBucketOrd) throws IOException {
                final List<List<Object>> terms = MultiTermsAggregator.docTerms(termValuesList, doc);
                if (terms != null) {
                    final ArrayList path = new ArrayList(terms.size());
                    new CheckedConsumer<Integer, IOException>(){

                        public void accept(Integer start) throws IOException {
                            for (Object term : (List)terms.get(start)) {
                                if (start.intValue() == path.size()) {
                                    path.add(term);
                                } else {
                                    path.set(start, term);
                                }
                                if (start < terms.size() - 1) {
                                    this.accept(start + 1);
                                    continue;
                                }
                                long bucketOrd = MultiTermsAggregator.this.bucketOrds.add(owningBucketOrd, MultiTermsAggregator.packKey(path));
                                if (bucketOrd < 0L) {
                                    bucketOrd = -1L - bucketOrd;
                                    MultiTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                    continue;
                                }
                                MultiTermsAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                    }.accept(0);
                }
            }
        };
    }

    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        InternalMultiTerms.Bucket[][] topBucketsPerOrd = new InternalMultiTerms.Bucket[owningBucketOrds.length][];
        long[] otherDocCounts = new long[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            long bucketsInOrd = this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
            int size = (int)Math.min(bucketsInOrd, (long)this.bucketCountThresholds.getShardSize());
            BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.partiallyBuiltBucketComparator);
            InternalMultiTerms.Bucket spare = null;
            BytesRef spareKey = null;
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] + docCount;
                if (docCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
                if (spare == null) {
                    spare = new InternalMultiTerms.Bucket(null, 0L, null, this.showTermDocCountError, 0L, this.formats, this.keyConverters);
                    spareKey = new BytesRef();
                }
                ordsEnum.readValue(spareKey);
                spare.terms = MultiTermsAggregator.unpackTerms(spareKey);
                spare.docCount = docCount;
                spare.bucketOrd = ordsEnum.ord();
                spare = (InternalMultiTerms.Bucket)((Object)ordered.insertWithOverflow((Object)spare));
            }
            InternalMultiTerms.Bucket[] bucketsForOrd = new InternalMultiTerms.Bucket[ordered.size()];
            topBucketsPerOrd[ordIdx] = bucketsForOrd;
            for (int b2 = ordered.size() - 1; b2 >= 0; --b2) {
                topBucketsPerOrd[ordIdx][b2] = (InternalMultiTerms.Bucket)((Object)ordered.pop());
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][b2].getDocCount();
            }
        }
        this.buildSubAggsForAllBuckets((Object[][])topBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
            b.aggregations = a;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    InternalMultiTerms buildResult(long otherDocCount, InternalMultiTerms.Bucket[] topBuckets) {
        BucketOrder reduceOrder;
        if (!InternalOrder.isKeyOrder((BucketOrder)this.order)) {
            reduceOrder = InternalOrder.key((boolean)true);
            Arrays.sort(topBuckets, reduceOrder.comparator());
        } else {
            reduceOrder = this.order;
        }
        return new InternalMultiTerms(this.name, reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, this.formats, this.keyConverters, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMultiTerms(this.name, this.order, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, this.formats, this.keyConverters, this.metadata());
    }

    static TermValuesSource buildNumericTermValues(ValuesSourceConfig config) {
        ValuesSource.Numeric vs = (ValuesSource.Numeric)config.getValuesSource();
        if (vs.isFloatingPoint()) {
            return new DoubleTermValuesSource(config);
        }
        return new LongTermValuesSource(config);
    }

    static interface TermValuesSource {
        public TermValues getValues(LeafReaderContext var1) throws IOException;

        public InternalMultiTerms.KeyConverter keyConverter();
    }

    static interface TermValues {
        public List<Object> collectValues(int var1) throws IOException;
    }

    static class DoubleTermValuesSource
    implements TermValuesSource {
        final ValuesSource.Numeric source;

        DoubleTermValuesSource(ValuesSourceConfig config) {
            this.source = (ValuesSource.Numeric)config.getValuesSource();
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedNumericDoubleValues values = this.source.doubleValues(ctx);
            return doc -> {
                if (values.advanceExact(doc)) {
                    ArrayList<Double> objects = new ArrayList<Double>();
                    int valuesCount = values.docValueCount();
                    double previous = Double.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        double val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        objects.add(val);
                        previous = val;
                    }
                    return objects;
                }
                return null;
            };
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.DOUBLE;
        }
    }

    static class LongTermValuesSource
    implements TermValuesSource {
        final ValuesSource.Numeric source;
        final InternalMultiTerms.KeyConverter converter;

        LongTermValuesSource(ValuesSourceConfig config) {
            this.source = (ValuesSource.Numeric)config.getValuesSource();
            this.converter = config.format() == DocValueFormat.UNSIGNED_LONG_SHIFTED ? InternalMultiTerms.KeyConverter.UNSIGNED_LONG : InternalMultiTerms.KeyConverter.LONG;
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedNumericDocValues values = this.source.longValues(ctx);
            return doc -> {
                if (values.advanceExact(doc)) {
                    ArrayList<Long> objects = new ArrayList<Long>();
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        objects.add(val);
                        previous = val;
                    }
                    return objects;
                }
                return null;
            };
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return this.converter;
        }
    }

    static class IPTermValuesSource
    extends BinaryTermValuesSource {
        IPTermValuesSource(ValuesSourceConfig source) {
            super(source);
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.IP;
        }
    }

    static class StringTermValuesSource
    extends BinaryTermValuesSource {
        StringTermValuesSource(ValuesSourceConfig source) {
            super(source);
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.STRING;
        }
    }

    static abstract class BinaryTermValuesSource
    implements TermValuesSource {
        private final ValuesSource source;
        final BytesRefBuilder previous = new BytesRefBuilder();

        BinaryTermValuesSource(ValuesSourceConfig source) {
            this.source = source.getValuesSource();
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedBinaryDocValues values = this.source.bytesValues(ctx);
            return doc -> {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    ArrayList<BytesRef> objects = new ArrayList<BytesRef>(valuesCount);
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        this.previous.copyBytes(bytes);
                        objects.add(BytesRef.deepCopyOf((BytesRef)bytes));
                    }
                    return objects;
                }
                return null;
            };
        }
    }
}

