/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

@ServerlessScope(value=Scope.PUBLIC)
public class RestStartTrainedModelDeploymentAction
extends BaseRestHandler {
    public String getName() {
        return "xpack_ml_start_trained_models_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/trained_models/{" + StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName() + "}/deployment/_start"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StartTrainedModelDeploymentAction.Request request;
        String modelId = restRequest.param(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName());
        String deploymentId = restRequest.param(StartTrainedModelDeploymentAction.Request.DEPLOYMENT_ID.getPreferredName(), modelId);
        if (restRequest.hasContentOrSourceParam()) {
            request = StartTrainedModelDeploymentAction.Request.parseRequest((String)modelId, (String)deploymentId, (XContentParser)restRequest.contentOrSourceParamParser());
        } else {
            request = new StartTrainedModelDeploymentAction.Request(modelId, deploymentId);
            if (restRequest.hasParam(StartTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName())) {
                TimeValue openTimeout = restRequest.paramAsTime(StartTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName(), StartTrainedModelDeploymentAction.DEFAULT_TIMEOUT);
                request.setTimeout(openTimeout);
            }
            request.setWaitForState(AllocationStatus.State.fromString((String)restRequest.param(StartTrainedModelDeploymentAction.Request.WAIT_FOR.getPreferredName(), AllocationStatus.State.STARTED.toString())));
            RestCompatibilityChecker.checkAndSetDeprecatedParam(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getDeprecatedNames()[0], StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName(), RestApiVersion.V_8, restRequest, (r, s) -> r.paramAsInt(s, request.getNumberOfAllocations()), arg_0 -> ((StartTrainedModelDeploymentAction.Request)request).setNumberOfAllocations(arg_0));
            RestCompatibilityChecker.checkAndSetDeprecatedParam(StartTrainedModelDeploymentAction.Request.THREADS_PER_ALLOCATION.getDeprecatedNames()[0], StartTrainedModelDeploymentAction.Request.THREADS_PER_ALLOCATION.getPreferredName(), RestApiVersion.V_8, restRequest, (r, s) -> r.paramAsInt(s, request.getThreadsPerAllocation()), arg_0 -> ((StartTrainedModelDeploymentAction.Request)request).setThreadsPerAllocation(arg_0));
            request.setQueueCapacity(restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.QUEUE_CAPACITY.getPreferredName(), request.getQueueCapacity()));
            if (restRequest.hasParam(StartTrainedModelDeploymentAction.Request.CACHE_SIZE.getPreferredName())) {
                request.setCacheSize(ByteSizeValue.parseBytesSizeValue((String)restRequest.param(StartTrainedModelDeploymentAction.Request.CACHE_SIZE.getPreferredName()), (String)StartTrainedModelDeploymentAction.Request.CACHE_SIZE.getPreferredName()));
            }
            request.setQueueCapacity(restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.QUEUE_CAPACITY.getPreferredName(), request.getQueueCapacity()));
            request.setPriority(restRequest.param(StartTrainedModelDeploymentAction.TaskParams.PRIORITY.getPreferredName(), request.getPriority().toString()));
        }
        return channel -> client.execute((ActionType)StartTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

