/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache;

import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class BlobCacheMetrics {
    private final LongCounter cacheMissCounter;
    private final LongCounter evictedCountNonZeroFrequency;
    private final LongHistogram cacheMissLoadTimes;
    public static BlobCacheMetrics NOOP = new BlobCacheMetrics(TelemetryProvider.NOOP.getMeterRegistry());

    public BlobCacheMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry.registerLongCounter("elasticsearch.blob_cache.miss_that_triggered_read", "The number of times there was a cache miss that triggered a read from the blob store", "count"), meterRegistry.registerLongCounter("elasticsearch.blob_cache.count_of_evicted_used_regions", "The number of times a cache entry was evicted where the frequency was not zero", "entries"), meterRegistry.registerLongHistogram("elasticsearch.blob_cache.cache_miss_load_times", "The timing data for populating entries in the blob store resulting from a cache miss.", "count"));
    }

    BlobCacheMetrics(LongCounter cacheMissCounter, LongCounter evictedCountNonZeroFrequency, LongHistogram cacheMissLoadTimes) {
        this.cacheMissCounter = cacheMissCounter;
        this.evictedCountNonZeroFrequency = evictedCountNonZeroFrequency;
        this.cacheMissLoadTimes = cacheMissLoadTimes;
    }

    public LongCounter getCacheMissCounter() {
        return this.cacheMissCounter;
    }

    public LongCounter getEvictedCountNonZeroFrequency() {
        return this.evictedCountNonZeroFrequency;
    }

    public LongHistogram getCacheMissLoadTimes() {
        return this.cacheMissLoadTimes;
    }
}

