/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.time.Clock;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnRequest;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnResponse;
import org.elasticsearch.xpack.idp.privileges.UserPrivilegeResolver;
import org.elasticsearch.xpack.idp.saml.authn.FailedAuthenticationResponseMessageBuilder;
import org.elasticsearch.xpack.idp.saml.authn.SuccessfulAuthenticationResponseMessageBuilder;
import org.elasticsearch.xpack.idp.saml.authn.UserServiceAuthentication;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInitiateSingleSignOnException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Response;

public class TransportSamlInitiateSingleSignOnAction
extends HandledTransportAction<SamlInitiateSingleSignOnRequest, SamlInitiateSingleSignOnResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSamlInitiateSingleSignOnAction.class);
    private final SecurityContext securityContext;
    private final SamlIdentityProvider identityProvider;
    private final SamlFactory samlFactory;
    private final UserPrivilegeResolver privilegeResolver;

    @Inject
    public TransportSamlInitiateSingleSignOnAction(TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext, SamlIdentityProvider idp, SamlFactory factory, UserPrivilegeResolver privilegeResolver) {
        super("cluster:admin/idp/saml/init", transportService, actionFilters, SamlInitiateSingleSignOnRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.securityContext = securityContext;
        this.identityProvider = idp;
        this.samlFactory = factory;
        this.privilegeResolver = privilegeResolver;
    }

    protected void doExecute(Task task, SamlInitiateSingleSignOnRequest request, ActionListener<SamlInitiateSingleSignOnResponse> listener) {
        SamlAuthenticationState authenticationState = request.getSamlAuthenticationState();
        this.identityProvider.resolveServiceProvider(request.getSpEntityId(), request.getAssertionConsumerService(), false, (ActionListener<SamlServiceProvider>)ActionListener.wrap(sp -> {
            if (null == sp) {
                this.writeFailureResponse(listener, this.buildSamlInitiateSingleSignOnException(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Responder", RestStatus.BAD_REQUEST, "Service Provider with Entity ID [{}] and ACS [{}] is not known to this Identity Provider", request.getSpEntityId(), request.getAssertionConsumerService()));
                return;
            }
            SecondaryAuthentication secondaryAuthentication = SecondaryAuthentication.readFromContext((SecurityContext)this.securityContext);
            if (secondaryAuthentication == null) {
                this.writeFailureResponse(listener, this.buildSamlInitiateSingleSignOnException(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Requester", RestStatus.FORBIDDEN, "Request is missing secondary authentication", new Object[0]));
                return;
            }
            this.buildUserFromAuthentication(secondaryAuthentication, (SamlServiceProvider)sp, (ActionListener<UserServiceAuthentication>)ActionListener.wrap(user -> {
                if (user == null) {
                    this.writeFailureResponse(listener, this.buildSamlInitiateSingleSignOnException(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Requester", RestStatus.FORBIDDEN, "User [{}] is not permitted to access service [{}]", secondaryAuthentication.getUser().principal(), sp.getEntityId()));
                    return;
                }
                SuccessfulAuthenticationResponseMessageBuilder builder = new SuccessfulAuthenticationResponseMessageBuilder(this.samlFactory, Clock.systemUTC(), this.identityProvider);
                try {
                    Response response = builder.build((UserServiceAuthentication)user, authenticationState);
                    listener.onResponse((Object)new SamlInitiateSingleSignOnResponse(user.getServiceProvider().getEntityId(), user.getServiceProvider().getAssertionConsumerService().toString(), this.samlFactory.getXmlContent((SAMLObject)response), "urn:oasis:names:tc:SAML:2.0:status:Success", null));
                }
                catch (ElasticsearchException e) {
                    listener.onFailure((Exception)((Object)e));
                }
            }, e -> this.writeFailureResponse(listener, this.buildResponderSamlInitiateSingleSignOnException(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), (Exception)e))));
        }, e -> this.writeFailureResponse(listener, this.buildResponderSamlInitiateSingleSignOnException(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), (Exception)e))));
    }

    private void buildUserFromAuthentication(SecondaryAuthentication secondaryAuthentication, SamlServiceProvider serviceProvider, ActionListener<UserServiceAuthentication> listener) {
        User user = secondaryAuthentication.getUser();
        secondaryAuthentication.execute(ignore -> {
            ActionListener wrapped = ActionListener.wrap(userPrivileges -> {
                if (!userPrivileges.hasAccess) {
                    listener.onResponse(null);
                } else {
                    logger.debug("Resolved [{}] for [{}]", userPrivileges, (Object)user);
                    listener.onResponse((Object)new UserServiceAuthentication(user.principal(), user.fullName(), user.email(), userPrivileges.roles, serviceProvider));
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            this.privilegeResolver.resolve(serviceProvider.getPrivileges(), (ActionListener<UserPrivilegeResolver.UserPrivileges>)wrapped);
            return null;
        });
    }

    private void writeFailureResponse(ActionListener<SamlInitiateSingleSignOnResponse> listener, SamlInitiateSingleSignOnException ex) {
        logger.debug("Failed to generate a successful SAML response: ", (Throwable)((Object)ex));
        listener.onFailure((Exception)((Object)ex));
    }

    private SamlInitiateSingleSignOnException buildSamlInitiateSingleSignOnException(SamlAuthenticationState authenticationState, String spEntityId, String acsUrl, String statusCode, RestStatus restStatus, String messageFormatStr, Object ... args) {
        SamlInitiateSingleSignOnException ex;
        String exceptionMessage = LoggerMessageFormat.format((String)messageFormatStr, (Object[])args);
        if (authenticationState != null) {
            FailedAuthenticationResponseMessageBuilder builder = new FailedAuthenticationResponseMessageBuilder(this.samlFactory, Clock.systemUTC(), this.identityProvider).setInResponseTo(authenticationState.getAuthnRequestId()).setAcsUrl(acsUrl).setPrimaryStatusCode(statusCode);
            Response response = builder.build();
            ex = new SamlInitiateSingleSignOnException(exceptionMessage, restStatus, new SamlInitiateSingleSignOnResponse(spEntityId, acsUrl, this.samlFactory.getXmlContent((SAMLObject)response), statusCode, exceptionMessage));
        } else {
            ex = new SamlInitiateSingleSignOnException(exceptionMessage, restStatus);
        }
        return ex;
    }

    private SamlInitiateSingleSignOnException buildResponderSamlInitiateSingleSignOnException(SamlAuthenticationState authenticationState, String spEntityId, String acsUrl, Exception cause) {
        String exceptionMessage = cause.getMessage();
        RestStatus restStatus = ExceptionsHelper.status((Throwable)cause);
        SamlInitiateSingleSignOnException ex = this.buildSamlInitiateSingleSignOnException(authenticationState, spEntityId, acsUrl, "urn:oasis:names:tc:SAML:2.0:status:Responder", restStatus, exceptionMessage, new Object[0]);
        ex.initCause(cause);
        return ex;
    }
}

