/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.ql.analyzer.PreAnalyzer;
import org.elasticsearch.xpack.ql.analyzer.TableInfo;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.index.IndexCompatibility;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.index.MappingException;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.analysis.analyzer.Analyzer;
import org.elasticsearch.xpack.sql.analysis.analyzer.AnalyzerContext;
import org.elasticsearch.xpack.sql.analysis.analyzer.Verifier;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.optimizer.Optimizer;
import org.elasticsearch.xpack.sql.parser.SqlParser;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.planner.Planner;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Session;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;

public class SqlSession
implements Session {
    private final Client client;
    private final FunctionRegistry functionRegistry;
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final Optimizer optimizer;
    private final Planner planner;
    private final PlanExecutor planExecutor;
    private final SqlConfiguration configuration;

    public SqlSession(SqlConfiguration configuration, Client client, FunctionRegistry functionRegistry, IndexResolver indexResolver, PreAnalyzer preAnalyzer, Verifier verifier, Optimizer optimizer, Planner planner, PlanExecutor planExecutor) {
        this.client = configuration.taskId() != null ? new ParentTaskAssigningClient(client, configuration.taskId()) : client;
        this.functionRegistry = functionRegistry;
        this.indexResolver = indexResolver;
        this.preAnalyzer = preAnalyzer;
        this.optimizer = optimizer;
        this.planner = planner;
        this.verifier = verifier;
        this.configuration = configuration;
        this.planExecutor = planExecutor;
    }

    public FunctionRegistry functionRegistry() {
        return this.functionRegistry;
    }

    public Client client() {
        return this.client;
    }

    public Planner planner() {
        return this.planner;
    }

    public IndexResolver indexResolver() {
        return this.indexResolver;
    }

    public Optimizer optimizer() {
        return this.optimizer;
    }

    public Verifier verifier() {
        return this.verifier;
    }

    public PlanExecutor planExecutor() {
        return this.planExecutor;
    }

    private LogicalPlan doParse(String sql, List<SqlTypedParamValue> params) {
        return new SqlParser().createStatement(sql, params, this.configuration.zoneId());
    }

    public void analyzedPlan(LogicalPlan parsed, boolean verify, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, r -> {
            AnalyzerContext context = new AnalyzerContext(this.configuration, this.functionRegistry, IndexCompatibility.compatible((IndexResolution)r, (Version)Version.fromId((int)this.configuration.version().id)));
            Analyzer analyzer = new Analyzer(context, this.verifier);
            return analyzer.analyze(parsed, verify);
        }, listener);
    }

    public void debugAnalyzedPlan(LogicalPlan parsed, ActionListener<RuleExecutor.ExecutionInfo> listener) {
        if (parsed.analyzed()) {
            listener.onResponse(null);
            return;
        }
        this.preAnalyze(parsed, r -> {
            AnalyzerContext context = new AnalyzerContext(this.configuration, this.functionRegistry, (IndexResolution)r);
            Analyzer analyzer = new Analyzer(context, this.verifier);
            return analyzer.debugAnalyze(parsed);
        }, listener);
    }

    private <T> void preAnalyze(LogicalPlan parsed, Function<IndexResolution, T> action, ActionListener<T> listener) {
        if (this.configuration.task() != null && this.configuration.task().isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("cancelled"));
            return;
        }
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        if (preAnalysis.indices.size() > 1) {
            listener.onFailure((Exception)new MappingException("Queries with multiple indices are not supported", new Object[0]));
        } else if (preAnalysis.indices.size() == 1) {
            TableInfo tableInfo = (TableInfo)preAnalysis.indices.get(0);
            TableIdentifier table = tableInfo.id();
            String cluster = table.cluster();
            cluster = Strings.hasText((String)cluster) ? cluster : this.configuration.catalog();
            String indexPattern = Strings.hasText((String)cluster) && !cluster.equals(this.configuration.clusterName()) ? RemoteClusterAware.buildRemoteIndexName((String)cluster, (String)table.index()) : table.index();
            boolean includeFrozen = this.configuration.includeFrozen() || tableInfo.isFrozen();
            this.indexResolver.resolveAsMergedMapping(indexPattern, IndexResolver.ALL_FIELDS, includeFrozen, this.configuration.runtimeMappings(), listener.delegateFailureAndWrap((l, indexResult) -> l.onResponse(action.apply((IndexResolution)indexResult))));
        } else {
            try {
                listener.onResponse(action.apply(IndexResolution.invalid((String)"[none specified]")));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }
    }

    public void optimizedPlan(LogicalPlan verified, ActionListener<LogicalPlan> listener) {
        this.analyzedPlan(verified, true, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((l, v) -> l.onResponse((Object)this.optimizer.optimize((LogicalPlan)v))));
    }

    public void physicalPlan(LogicalPlan optimized, boolean verify, ActionListener<PhysicalPlan> listener) {
        this.optimizedPlan(optimized, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((l, o) -> l.onResponse((Object)this.planner.plan((LogicalPlan)o, verify))));
    }

    public void sql(String sql, List<SqlTypedParamValue> params, ActionListener<Cursor.Page> listener) {
        this.sqlExecutable(sql, params, (ActionListener<PhysicalPlan>)listener.delegateFailureAndWrap((l, e) -> e.execute(this, l)));
    }

    public void sqlExecutable(String sql, List<SqlTypedParamValue> params, ActionListener<PhysicalPlan> listener) {
        try {
            this.physicalPlan(this.doParse(sql, params), true, listener);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public SqlConfiguration configuration() {
        return this.configuration;
    }
}

