/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal.interval;

import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.temporal.Temporal;

public final class IntervalArithmetics {
    public static final long DAY_IN_MILLIS = 86400000L;

    private IntervalArithmetics() {
    }

    public static Temporal add(Temporal l, Period r) {
        return IntervalArithmetics.periodArithmetics(l, r, IntervalOperation.ADD);
    }

    public static Temporal add(Temporal l, Duration r) {
        return IntervalArithmetics.durationArithmetics(l, r, IntervalOperation.ADD);
    }

    public static Temporal sub(Temporal l, Period r) {
        return IntervalArithmetics.periodArithmetics(l, r, IntervalOperation.SUB);
    }

    public static Temporal sub(Temporal l, Duration r) {
        return IntervalArithmetics.durationArithmetics(l, r, IntervalOperation.SUB);
    }

    private static Temporal periodArithmetics(Temporal l, Period r, IntervalOperation operation) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof OffsetTime) {
            return l;
        }
        if (operation == IntervalOperation.ADD) {
            return l.plus(r);
        }
        return l.minus(r);
    }

    private static Temporal durationArithmetics(Temporal l, Duration r, IntervalOperation operation) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof OffsetTime) {
            r = Duration.ofMillis(r.toMillis() % 86400000L);
        }
        if (operation == IntervalOperation.ADD) {
            return l.plus(r);
        }
        return l.minus(r);
    }

    private static enum IntervalOperation {
        ADD,
        SUB;

    }
}

