/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class GoogleCloudStorageRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageRepository.class);
    static final ByteSizeValue MIN_CHUNK_SIZE = ByteSizeValue.ONE;
    static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final String TYPE = "gcs";
    static final Setting<String> BUCKET = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private final GoogleCloudStorageService storageService;
    private final ByteSizeValue chunkSize;
    private final String bucket;
    private final String clientName;

    GoogleCloudStorageRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, GoogleCloudStorageService storageService, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, GoogleCloudStorageRepository.buildBasePath(metadata), GoogleCloudStorageRepository.buildLocation(metadata), MeterRegistry.NOOP);
        this.storageService = storageService;
        this.chunkSize = GoogleCloudStorageRepository.getSetting(CHUNK_SIZE, metadata);
        this.bucket = GoogleCloudStorageRepository.getSetting(BUCKET, metadata);
        this.clientName = (String)CLIENT_NAME.get(metadata.settings());
        logger.debug("using bucket [{}], base_path [{}], chunk_size [{}], compress [{}]", (Object)this.bucket, (Object)this.basePath(), (Object)this.chunkSize, (Object)this.isCompress());
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)BASE_PATH.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = BlobPath.EMPTY;
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.EMPTY;
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH.get(metadata.settings()), "bucket", GoogleCloudStorageRepository.getSetting(BUCKET, metadata));
    }

    protected GoogleCloudStorageBlobStore createBlobStore() {
        return new GoogleCloudStorageBlobStore(this.bucket, this.clientName, this.metadata.name(), this.storageService, this.bigArrays, this.bufferSize);
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    static <T> T getSetting(Setting<T> setting, RepositoryMetadata metadata) {
        String string;
        Object value = setting.get(metadata.settings());
        if (value == null) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is not defined for repository", new Object[0]);
        }
        if (value instanceof String && !Strings.hasText((String)(string = (String)value))) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is empty for repository", new Object[0]);
        }
        return (T)value;
    }
}

