/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.ForkingResponseHandlerRunnable;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportNotReadyException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent
implements ReportingService<TransportInfo>,
TransportMessageListener,
TransportConnectionListener {
    private static final Logger logger = LogManager.getLogger(TransportService.class);
    private static final String SERVERLESS_TRANSPORT_SYSTEM_PROPERTY = "es.serverless_transport";
    private static final boolean SERVERLESS_TRANSPORT_FEATURE_FLAG = Booleans.parseBoolean((String)System.getProperty("es.serverless_transport"), (boolean)false);
    public static final String DIRECT_RESPONSE_PROFILE = ".direct";
    public static final String HANDSHAKE_ACTION_NAME = "internal:transport/handshake";
    private final AtomicBoolean handleIncomingRequests = new AtomicBoolean();
    private final DelegatingTransportMessageListener messageListener = new DelegatingTransportMessageListener();
    protected final Transport transport;
    protected final ConnectionManager connectionManager;
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TaskManager taskManager;
    private final TransportInterceptor.AsyncSender asyncSender;
    private final Function<BoundTransportAddress, DiscoveryNode> localNodeFactory;
    private final boolean remoteClusterClient;
    private final Transport.ResponseHandlers responseHandlers;
    private final TransportInterceptor interceptor;
    private final PendingDirectHandlers pendingDirectHandlers = new PendingDirectHandlers();
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, TimeoutInfoHolder> eldest) {
            return this.size() > 100;
        }
    });
    public static final TransportInterceptor NOOP_TRANSPORT_INTERCEPTOR = new TransportInterceptor(){};
    private final Logger tracerLog;
    private final Tracer tracer;
    volatile String[] tracerLogInclude;
    volatile String[] tracerLogExclude;
    private final RemoteClusterService remoteClusterService;
    volatile DiscoveryNode localNode = null;
    private final Transport.Connection localNodeConnection = new Transport.Connection(){

        @Override
        public DiscoveryNode getNode() {
            return TransportService.this.localNode;
        }

        @Override
        public TransportVersion getTransportVersion() {
            return TransportVersion.current();
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) {
            TransportService.this.sendLocalRequest(requestId, action, request, options);
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
        }

        @Override
        public void addRemovedListener(ActionListener<Void> listener) {
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public void close() {
            assert (false) : "should not close the local node connection";
        }

        public void incRef() {
        }

        public boolean tryIncRef() {
            return true;
        }

        public boolean decRef() {
            return false;
        }

        public boolean hasReferences() {
            return true;
        }

        @Override
        public void onRemoved() {
            assert (false) : "should not remove the local node connection";
        }

        public String toString() {
            return "local node connection";
        }
    };
    public static final Set<String> VALID_ACTION_PREFIXES = Set.of("indices:admin", "indices:monitor", "indices:data/write", "indices:data/read", "indices:internal", "cluster:admin", "cluster:monitor", "cluster:internal", "internal:");

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        this(settings, transport, threadPool, transportInterceptor, localNodeFactory, clusterSettings, taskHeaders, Tracer.NOOP);
    }

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, TaskManager taskManager, Tracer tracer) {
        this(settings, transport, threadPool, transportInterceptor, localNodeFactory, clusterSettings, new ClusterConnectionManager(settings, transport, threadPool.getThreadContext()), taskManager, tracer);
    }

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        this(settings, transport, threadPool, transportInterceptor, localNodeFactory, clusterSettings, new ClusterConnectionManager(settings, transport, threadPool.getThreadContext()), new TaskManager(settings, threadPool, taskHeaders), tracer);
    }

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, ConnectionManager connectionManager, TaskManager taskManger, Tracer tracer) {
        this.transport = transport;
        transport.setSlowLogThreshold(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING.get(settings));
        this.threadPool = threadPool;
        this.localNodeFactory = localNodeFactory;
        this.connectionManager = connectionManager;
        this.tracer = tracer;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.setTracerLogInclude(TransportSettings.TRACE_LOG_INCLUDE_SETTING.get(settings));
        this.setTracerLogExclude(TransportSettings.TRACE_LOG_EXCLUDE_SETTING.get(settings));
        this.tracerLog = Loggers.getLogger(logger, ".tracer");
        this.taskManager = taskManger;
        this.interceptor = transportInterceptor;
        this.asyncSender = this.interceptor.interceptSender(this::sendRequestInternal);
        this.remoteClusterClient = DiscoveryNode.isRemoteClusterClient(settings);
        this.remoteClusterService = new RemoteClusterService(settings, this);
        this.responseHandlers = transport.getResponseHandlers();
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.TRACE_LOG_INCLUDE_SETTING, this::setTracerLogInclude);
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.TRACE_LOG_EXCLUDE_SETTING, this::setTracerLogExclude);
            if (this.remoteClusterClient) {
                this.remoteClusterService.listenForUpdates(clusterSettings);
            }
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING, transport::setSlowLogThreshold);
        }
        this.registerRequestHandler(HANDSHAKE_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, false, false, HandshakeRequest::new, (request, channel, task) -> channel.sendResponse(new HandshakeResponse(this.localNode.getVersion(), Build.current().hash(), this.localNode, this.clusterName)));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.remoteClusterService;
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    public Transport.Connection getLocalNodeConnection() {
        return this.localNodeConnection;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
    }

    void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
    }

    @Override
    protected void doStart() {
        this.transport.setMessageListener(this);
        this.connectionManager.addListener(this);
        this.transport.start();
        if (this.transport.boundAddress() != null && logger.isInfoEnabled()) {
            logger.info("{}", (Object)this.transport.boundAddress());
            for (Map.Entry<String, BoundTransportAddress> entry : this.transport.profileBoundAddresses().entrySet()) {
                logger.info("profile [{}]: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.localNode = this.localNodeFactory.apply(this.transport.boundAddress());
        if (this.remoteClusterClient) {
            this.remoteClusterService.initializeRemoteClusters();
        }
    }

    @Override
    protected void doStop() {
        try {
            Closeable[] closeableArray = new Closeable[4];
            closeableArray[0] = this.connectionManager;
            closeableArray[1] = this.remoteClusterService;
            closeableArray[2] = this.transport::stop;
            closeableArray[3] = this.pendingDirectHandlers::stop;
            IOUtils.close((Closeable[])closeableArray);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
                    try {
                        TransportResponseHandler<? extends TransportResponse> handler = holderToNotify.handler();
                        DiscoveryNode targetNode = holderToNotify.connection().getNode();
                        long requestId = holderToNotify.requestId();
                        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(holderToNotify.action())) {
                            this.tracerLog.trace("[{}][{}] pruning request for node [{}]", (Object)requestId, (Object)holderToNotify.action(), (Object)targetNode);
                        }
                        assert (!(this.transport instanceof TcpTransport) || targetNode.equals(this.localNode) || holderToNotify.connection().isClosed()) : "expected only responses for local " + this.localNode + " but found handler for [" + holderToNotify.action() + "] on open connection to " + targetNode;
                        SendRequestTransportException exception = new SendRequestTransportException(targetNode, holderToNotify.action(), new NodeClosedException(this.localNode));
                        Executor executor = handler.executor(this.threadPool);
                        if (executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                            handler.handleException(exception);
                            continue;
                        }
                        executor.execute(new ForkingResponseHandlerRunnable(handler, exception, this.threadPool, handler, exception){
                            final /* synthetic */ TransportResponseHandler val$handler;
                            final /* synthetic */ SendRequestTransportException val$exception;
                            {
                                this.val$handler = transportResponseHandler;
                                this.val$exception = sendRequestTransportException;
                                super(handler, transportException, threadPool);
                            }

                            @Override
                            protected void doRun() {
                                this.val$handler.handleException(this.val$exception);
                            }
                        });
                    }
                    catch (Exception e2) {
                        assert (false) : e2;
                        logger.warn(() -> Strings.format((String)"failed to notify response handler on shutdown, action: %s", (Object[])new Object[]{holderToNotify.action()}), (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
        for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
            try {
                TransportResponseHandler<? extends TransportResponse> handler = holderToNotify.handler();
                DiscoveryNode targetNode = holderToNotify.connection().getNode();
                long requestId = holderToNotify.requestId();
                if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(holderToNotify.action())) {
                    this.tracerLog.trace("[{}][{}] pruning request for node [{}]", (Object)requestId, (Object)holderToNotify.action(), (Object)targetNode);
                }
                assert (!(this.transport instanceof TcpTransport) || targetNode.equals(this.localNode) || holderToNotify.connection().isClosed()) : "expected only responses for local " + this.localNode + " but found handler for [" + holderToNotify.action() + "] on open connection to " + targetNode;
                SendRequestTransportException exception = new SendRequestTransportException(targetNode, holderToNotify.action(), new NodeClosedException(this.localNode));
                Executor executor = handler.executor(this.threadPool);
                if (executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                    handler.handleException(exception);
                    continue;
                }
                executor.execute(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                assert (false) : e;
                logger.warn(() -> Strings.format((String)"failed to notify response handler on shutdown, action: %s", (Object[])new Object[]{holderToNotify.action()}), (Throwable)e);
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.transport.close();
    }

    public final void acceptIncomingRequests() {
        boolean startedWithThisCall = this.handleIncomingRequests.compareAndSet(false, true);
        assert (startedWithThisCall) : "transport service was already accepting incoming requests";
        logger.debug("now accepting incoming requests");
    }

    @Override
    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        Map<String, BoundTransportAddress> profileAddresses = this.transport.profileBoundAddresses();
        if (this.remoteClusterService.isRemoteClusterServerEnabled()) {
            Map<String, BoundTransportAddress> filteredProfileAddress = profileAddresses.entrySet().stream().filter(entry -> false == "_remote_cluster".equals(entry.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            return new TransportInfo(boundTransportAddress, filteredProfileAddress);
        }
        return new TransportInfo(boundTransportAddress, profileAddresses);
    }

    public TransportStats stats() {
        return this.transport.getStats();
    }

    public boolean isTransportSecure() {
        return this.transport.isSecure();
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public BoundTransportAddress boundRemoteAccessAddress() {
        return this.transport.boundRemoteIngressAddress();
    }

    public List<String> getDefaultSeedAddresses() {
        return this.transport.getDefaultSeedAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.isLocalNode(node) || this.connectionManager.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node, ActionListener<Releasable> listener) throws ConnectTransportException {
        this.connectToNode(node, null, listener);
    }

    public void connectToNode(DiscoveryNode node, @Nullable ConnectionProfile connectionProfile, ActionListener<Releasable> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(null);
            return;
        }
        this.connectionManager.connectToNode(node, connectionProfile, this.connectionValidator(node), listener);
    }

    public ConnectionManager.ConnectionValidator connectionValidator(DiscoveryNode node) {
        return (newConnection, actualProfile, listener) -> this.handshake(newConnection, actualProfile.getHandshakeTimeout(), cn -> true, listener.map(resp -> {
            DiscoveryNode remote = resp.discoveryNode;
            if (!node.equals(remote)) {
                throw new ConnectTransportException(node, "handshake failed. unexpected remote node " + remote);
            }
            return null;
        }));
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(this.localNodeConnection);
        } else {
            this.connectionManager.openConnection(node, connectionProfile, listener);
        }
    }

    public void handshake(Transport.Connection connection, TimeValue handshakeTimeout, ActionListener<DiscoveryNode> listener) {
        this.handshake(connection, handshakeTimeout, this.clusterName.getEqualityPredicate(), listener.map(HandshakeResponse::getDiscoveryNode));
    }

    public void handshake(Transport.Connection connection, TimeValue handshakeTimeout, Predicate<ClusterName> clusterNamePredicate, ActionListener<HandshakeResponse> listener) {
        DiscoveryNode node = connection.getNode();
        this.sendRequest(connection, HANDSHAKE_ACTION_NAME, (TransportRequest)HandshakeRequest.INSTANCE, TransportRequestOptions.timeout(handshakeTimeout), new ActionListenerResponseHandler<HandshakeResponse>(listener.delegateFailure((l, response) -> {
            if (!clusterNamePredicate.test(response.clusterName)) {
                l.onFailure(new IllegalStateException("handshake with [" + node + "] failed: remote cluster name [" + response.clusterName.value() + "] does not match " + clusterNamePredicate));
            } else if (!response.version.isCompatible(this.localNode.getVersion())) {
                l.onFailure(new IllegalStateException("handshake with [" + node + "] failed: remote node version [" + response.version + "] is incompatible with local node version [" + this.localNode.getVersion() + "]"));
            } else {
                l.onResponse(response);
            }
        }), HandshakeResponse::new, this.threadPool.generic()));
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public RecyclerBytesStreamOutput newNetworkBytesStream() {
        return this.transport.newNetworkBytesStream();
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.connectionManager.disconnectFromNode(node);
    }

    public void addMessageListener(TransportMessageListener listener) {
        this.messageListener.listeners.add(listener);
    }

    public void removeMessageListener(TransportMessageListener listener) {
        this.messageListener.listeners.remove(listener);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.addListener(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.removeListener(listener);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        this.sendRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public final <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Transport.Connection connection = this.getConnectionOrFail(node, action, handler);
        if (connection != null) {
            this.sendRequest(connection, action, request, options, handler);
        }
    }

    @Nullable
    private Transport.Connection getConnectionOrFail(DiscoveryNode node, String action, TransportResponseHandler<?> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            if (connection == null) {
                NodeNotConnectedException ex = new NodeNotConnectedException(node, "Node not connected");
                assert (false) : ex;
                throw ex;
            }
            return connection;
        }
        catch (TransportException transportException) {
            assert (transportException instanceof NodeNotConnectedException) : transportException;
            TransportService.handleSendRequestException(handler, transportException);
            return null;
        }
        catch (Exception exception) {
            assert (false) : exception;
            TransportService.handleSendRequestException(handler, new SendRequestTransportException(node, action, exception));
            return null;
        }
    }

    public static Transport.Connection unwrapConnection(Transport.Connection connection) {
        Transport.Connection unwrapped = connection;
        while (unwrapped instanceof RemoteConnectionManager.ProxyConnection) {
            RemoteConnectionManager.ProxyConnection proxyConnection = (RemoteConnectionManager.ProxyConnection)unwrapped;
            unwrapped = proxyConnection.getConnection();
        }
        return unwrapped;
    }

    public final <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            TransportResponseHandler<T> delegate;
            if (request.getParentTask().isSet()) {
                Transport.Connection unwrappedConn = TransportService.unwrapConnection(connection);
                Releasable unregisterChildNode = this.taskManager.registerChildConnection(request.getParentTask().getId(), unwrappedConn);
                delegate = unregisterChildNode == null ? handler : new UnregisterChildTransportResponseHandler<T>(unregisterChildNode, handler, action, request, unwrappedConn, this.taskManager);
            } else {
                delegate = handler;
            }
            this.asyncSender.sendRequest(connection, action, request, options, delegate);
        }
        catch (TransportException transportException) {
            TransportService.handleSendRequestException(handler, transportException);
        }
        catch (Exception exception) {
            TransportService.handleSendRequestException(handler, new SendRequestTransportException(connection.getNode(), action, exception));
        }
    }

    private static void handleSendRequestException(TransportResponseHandler<?> handler, TransportException transportException) {
        block2: {
            try {
                handler.handleException(transportException);
            }
            catch (Exception innerException) {
                innerException.addSuppressed(transportException);
                logger.error("unexpected exception from handler.handleException", (Throwable)innerException);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)innerException);
            }
        }
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.connectionManager.getConnection(node);
    }

    public final <T extends TransportResponse> void sendChildRequest(DiscoveryNode node, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Transport.Connection connection = this.getConnectionOrFail(node, action, handler);
        if (connection != null) {
            this.sendChildRequest(connection, action, request, parentTask, options, handler);
        }
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportResponseHandler<T> handler) {
        this.sendChildRequest(connection, action, request, parentTask, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        request.setParentTask(this.localNode.getId(), parentTask.getId());
        this.sendRequest(connection, action, request, options, handler);
    }

    private <T extends TransportResponse> void sendRequestInternal(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TimeoutHandler timeoutHandler;
        if (connection == null) {
            throw new IllegalStateException("can't send request to a null connection");
        }
        DiscoveryNode node = connection.getNode();
        Supplier<ThreadContext.StoredContext> storedContextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        ContextRestoreResponseHandler<T> responseHandler = new ContextRestoreResponseHandler<T>(storedContextSupplier, handler);
        long requestId = this.responseHandlers.add(responseHandler, connection, action).requestId();
        request.setRequestId(requestId);
        if (options.timeout() != null) {
            timeoutHandler = new TimeoutHandler(requestId, connection.getNode(), action);
            responseHandler.setTimeoutHandler(timeoutHandler);
        } else {
            timeoutHandler = null;
        }
        if (this.lifecycle.stoppedOrClosed()) {
            this.handleInternalSendException(action, node, requestId, timeoutHandler, new NodeClosedException(this.localNode));
            return;
        }
        try {
            if (timeoutHandler != null) {
                assert (options.timeout() != null);
                timeoutHandler.scheduleTimeout(options.timeout());
            }
            logger.trace("sending internal request id [{}] action [{}] request [{}] options [{}]", (Object)requestId, (Object)action, (Object)request, (Object)options);
            connection.sendRequest(requestId, action, request, options);
        }
        catch (Exception e) {
            this.handleInternalSendException(action, node, requestId, timeoutHandler, e);
        }
    }

    protected void handleInternalSendException(final String action, final DiscoveryNode node, final long requestId, @Nullable TimeoutHandler timeoutHandler, Exception failure) {
        final Transport.ResponseContext<? extends TransportResponse> contextToNotify = this.responseHandlers.remove(requestId);
        if (contextToNotify == null) {
            logger.debug("Exception while sending request, handler likely already notified due to timeout", (Throwable)failure);
            return;
        }
        if (timeoutHandler != null) {
            timeoutHandler.cancel();
        }
        final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, failure);
        String executor = this.lifecycle.stoppedOrClosed() ? "same" : "generic";
        this.threadPool.executor(executor).execute(new AbstractRunnable(){

            @Override
            public void onRejection(Exception e) {
                logger.debug(() -> Strings.format((String)"failed to notify response handler on rejection, action: %s", (Object[])new Object[]{contextToNotify.action()}), (Throwable)e);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format((String)"failed to notify response handler on exception, action: %s", (Object[])new Object[]{contextToNotify.action()}), (Throwable)e);
            }

            @Override
            protected void doRun() {
                if (TransportService.this.tracerLog.isTraceEnabled() && TransportService.this.shouldTraceAction(action)) {
                    TransportService.this.tracerLog.trace("[{}][{}] failed to send request to node [{}]", (Object)requestId, (Object)action, (Object)node);
                }
                contextToNotify.handler().handleException(sendRequestException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalRequest(final long requestId, final String action, final TransportRequest request, TransportRequestOptions options) {
        block18: {
            final DirectResponseChannel channel = new DirectResponseChannel(this.localNode, action, requestId, this, this.threadPool);
            try {
                this.onRequestSent(this.localNode, requestId, action, request, options);
                this.onRequestReceived(requestId, action);
                final RequestHandlerRegistry<? extends TransportRequest> reg = this.getRequestHandler(action);
                if (reg == null) {
                    assert (false) : action;
                    throw new ActionNotFoundTransportException("Action [" + action + "] not found");
                }
                Executor executor = reg.getExecutor();
                if (executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                    try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
                        try {
                            reg.processMessageReceived(request, channel);
                        }
                        catch (Exception e) {
                            TransportService.handleSendToLocalException(channel, e, action);
                        }
                        break block18;
                    }
                }
                boolean success = false;
                request.mustIncRef();
                try {
                    executor.execute(this.threadPool.getThreadContext().preserveContextWithTracing(new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            reg.processMessageReceived(request, channel);
                        }

                        @Override
                        public boolean isForceExecution() {
                            return reg.isForceExecution();
                        }

                        @Override
                        public void onFailure(Exception e) {
                            TransportService.handleSendToLocalException(channel, e, action);
                        }

                        public String toString() {
                            return "processing of [" + requestId + "][" + action + "]: " + request;
                        }

                        @Override
                        public void onAfter() {
                            request.decRef();
                        }
                    }));
                    success = true;
                }
                finally {
                    if (!success) {
                        request.decRef();
                    }
                }
            }
            catch (Exception e) {
                assert (false) : e;
                TransportService.handleSendToLocalException(channel, e, action);
            }
        }
    }

    private static void handleSendToLocalException(DirectResponseChannel channel, Exception e, String action) {
        try {
            channel.sendResponse(e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.warn(() -> "failed to notify channel of error message for action [" + action + "]", (Throwable)inner);
        }
    }

    private boolean shouldTraceAction(String action) {
        return TransportService.shouldTraceAction(action, this.tracerLogInclude, this.tracerLogExclude);
    }

    public static boolean shouldTraceAction(String action, String[] include, String[] exclude) {
        if (include.length > 0 && !Regex.simpleMatch(include, action)) {
            return false;
        }
        if (exclude.length > 0) {
            return !Regex.simpleMatch(exclude, action);
        }
        return true;
    }

    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return this.transport.addressesFromString(address);
    }

    private static void validateActionName(String actionName) {
        if (!TransportService.isValidActionName(actionName)) {
            logger.warn("invalid action name [" + actionName + "] must start with one of: " + VALID_ACTION_PREFIXES);
        }
    }

    public static boolean isValidActionName(String actionName) {
        for (String prefix : VALID_ACTION_PREFIXES) {
            if (!actionName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Executor executor, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        TransportService.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, false, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, false, true, this.tracer);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Executor executor, boolean forceExecution, boolean canTripCircuitBreaker, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        TransportService.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, forceExecution, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker, this.tracer);
        this.transport.registerRequestHandler(reg);
    }

    @Override
    public void onRequestReceived(long requestId, String action) {
        if (!this.handleIncomingRequests.get()) {
            throw new TransportNotReadyException();
        }
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] received request", (Object)requestId, (Object)action);
        }
        this.messageListener.onRequestReceived(requestId, action);
    }

    @Override
    public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", (Object)requestId, (Object)action, (Object)node, (Object)options.timeout());
        }
        this.messageListener.onRequestSent(node, requestId, action, request, options);
    }

    @Override
    public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
        if (holder == null) {
            this.checkForTimeout(requestId);
        } else if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(holder.action())) {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)holder.action(), (Object)holder.connection().getNode());
        }
        this.messageListener.onResponseReceived(requestId, holder);
    }

    @Override
    public void onResponseSent(long requestId, String action, TransportResponse response) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] sent response", (Object)requestId, (Object)action);
        }
        this.messageListener.onResponseSent(requestId, action, response);
    }

    @Override
    public void onResponseSent(long requestId, String action, Exception e) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace(() -> Strings.format((String)"[%s][%s] sent error response", (Object[])new Object[]{requestId, action}), (Throwable)e);
        }
        this.messageListener.onResponseSent(requestId, action, e);
    }

    public RequestHandlerRegistry<? extends TransportRequest> getRequestHandler(String action) {
        return this.transport.getRequestHandlers().getHandler(action);
    }

    private void checkForTimeout(long requestId) {
        DiscoveryNode sourceNode;
        String action;
        assert (!this.responseHandlers.contains(requestId));
        TimeoutInfoHolder timeoutInfoHolder = this.timeoutInfoHandlers.remove(requestId);
        if (timeoutInfoHolder != null) {
            long time = this.threadPool.relativeTimeInMillis();
            long sentMs = time - timeoutInfoHolder.sentTime();
            long timedOutMs = time - timeoutInfoHolder.timeoutTime();
            logger.warn("Received response for a request that has timed out, sent [{}/{}ms] ago, timed out [{}/{}ms] ago, action [{}], node [{}], id [{}]", (Object)TimeValue.timeValueMillis((long)sentMs), (Object)sentMs, (Object)TimeValue.timeValueMillis((long)timedOutMs), (Object)timedOutMs, (Object)timeoutInfoHolder.action(), (Object)timeoutInfoHolder.node(), (Object)requestId);
            action = timeoutInfoHolder.action();
            sourceNode = timeoutInfoHolder.node();
        } else {
            logger.warn("Transport response handler not found of id [{}]", (Object)requestId);
            action = null;
            sourceNode = null;
        }
        if (!this.tracerLog.isTraceEnabled()) {
            return;
        }
        if (action == null) {
            assert (sourceNode == null);
            this.tracerLog.trace("[{}] received response but can't resolve it to a request", (Object)requestId);
        } else if (this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, action, sourceNode);
        }
    }

    @Override
    public void onConnectionClosed(final Transport.Connection connection) {
        final List<Transport.ResponseContext<? extends TransportResponse>> pruned = this.responseHandlers.prune(h -> h.connection().getCacheKey().equals(connection.getCacheKey()));
        if (pruned.isEmpty()) {
            return;
        }
        ExecutorService executor = this.threadPool.generic();
        assert (!executor.isShutdown()) : "connections should all be closed before threadpool shuts down";
        executor.execute(new AbstractRunnable(){

            @Override
            public void doRun() {
                for (Transport.ResponseContext holderToNotify : pruned) {
                    if (TransportService.this.tracerLog.isTraceEnabled() && TransportService.this.shouldTraceAction(holderToNotify.action())) {
                        TransportService.this.tracerLog.trace("[{}][{}] pruning request because connection to node [{}] closed", (Object)holderToNotify.requestId(), (Object)holderToNotify.action(), (Object)connection.getNode());
                    }
                    holderToNotify.handler().handleException(new NodeDisconnectedException(connection.getNode(), holderToNotify.action()));
                }
            }

            @Override
            public void onFailure(Exception e) {
                assert (false) : e;
                logger.warn(() -> "failed to notify response handler on connection close [" + connection + "]", (Throwable)e);
            }

            public String toString() {
                return "onConnectionClosed(" + connection.getNode() + ")";
            }
        });
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private boolean isLocalNode(DiscoveryNode discoveryNode) {
        if (discoveryNode == null) {
            throw new NodeNotConnectedException(discoveryNode, "discovery node must not be null");
        }
        return discoveryNode.equals(this.localNode);
    }

    static {
        String PERMIT_HANDSHAKES_FROM_INCOMPATIBLE_BUILDS_KEY = "es.unsafely_permit_handshake_from_incompatible_builds";
        if (System.getProperty("es.unsafely_permit_handshake_from_incompatible_builds") != null) {
            throw new IllegalArgumentException("system property [es.unsafely_permit_handshake_from_incompatible_builds] must not be set");
        }
    }

    private static final class DelegatingTransportMessageListener
    implements TransportMessageListener {
        private final List<TransportMessageListener> listeners = new CopyOnWriteArrayList<TransportMessageListener>();

        private DelegatingTransportMessageListener() {
        }

        @Override
        public void onRequestReceived(long requestId, String action) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestReceived(requestId, action);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, TransportResponse response) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action, response);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, Exception error) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action, error);
            }
        }

        @Override
        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions finalOptions) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestSent(node, requestId, action, request, finalOptions);
            }
        }

        @Override
        public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseReceived(requestId, holder);
            }
        }
    }

    private static class PendingDirectHandlers
    extends AbstractRefCounted {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);

        private PendingDirectHandlers() {
        }

        protected void closeInternal() {
            this.countDownLatch.countDown();
        }

        void stop() {
            this.decRef();
            try {
                boolean completed = this.countDownLatch.await(30L, TimeUnit.SECONDS);
                assert (completed) : "timed out waiting for all direct handlers to be enqueued";
            }
            catch (InterruptedException e) {
                assert (false) : e;
                Thread.currentThread().interrupt();
            }
        }

        @Nullable
        Releasable withRef() {
            if (this.tryIncRef()) {
                return () -> ((PendingDirectHandlers)this).decRef();
            }
            return null;
        }
    }

    static class HandshakeRequest
    extends TransportRequest {
        public static final HandshakeRequest INSTANCE = new HandshakeRequest();

        HandshakeRequest(StreamInput in) throws IOException {
            super(in);
        }

        private HandshakeRequest() {
        }
    }

    private record UnregisterChildTransportResponseHandler<T extends TransportResponse>(Releasable unregisterChildNode, TransportResponseHandler<T> handler, String action, TransportRequest childRequest, Transport.Connection childConnection, TaskManager taskManager) implements TransportResponseHandler<T>
    {
        @Override
        public void handleResponse(T response) {
            this.unregisterChildNode.close();
            this.handler.handleResponse(response);
        }

        @Override
        public void handleException(TransportException exp) {
            assert (this.childRequest.getParentTask().isSet());
            this.taskManager.cancelChildRemote(this.childRequest.getParentTask(), this.childRequest.getRequestId(), this.childConnection, exp.toString());
            this.unregisterChildNode.close();
            this.handler.handleException(exp);
        }

        @Override
        public Executor executor(ThreadPool threadPool) {
            return this.handler.executor(threadPool);
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.handler.read(in));
        }
    }

    public static final class ContextRestoreResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final TransportResponseHandler<T> delegate;
        private final Supplier<ThreadContext.StoredContext> contextSupplier;
        private volatile TimeoutHandler handler;

        public ContextRestoreResponseHandler(Supplier<ThreadContext.StoredContext> contextSupplier, TransportResponseHandler<T> delegate) {
            this.delegate = delegate;
            this.contextSupplier = contextSupplier;
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.delegate.read(in));
        }

        @Override
        public void handleResponse(T response) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleResponse(response);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleException(exp);
            }
        }

        @Override
        public Executor executor(ThreadPool threadPool) {
            return this.delegate.executor(threadPool);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.delegate.toString() + "]";
        }

        void setTimeoutHandler(TimeoutHandler timeoutHandler) {
            this.handler = timeoutHandler;
        }

        TransportResponseHandler<T> unwrap() {
            return this.delegate;
        }
    }

    final class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime;
        private final String action;
        private final DiscoveryNode node;
        volatile Scheduler.Cancellable cancellable;

        TimeoutHandler(long requestId, DiscoveryNode node, String action) {
            this.sentTime = TransportService.this.threadPool.relativeTimeInMillis();
            this.requestId = requestId;
            this.node = node;
            this.action = action;
        }

        @Override
        public void run() {
            if (TransportService.this.responseHandlers.contains(this.requestId)) {
                long timeoutTime = TransportService.this.threadPool.relativeTimeInMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(this.node, this.action, this.sentTime, timeoutTime));
                Transport.ResponseContext<? extends TransportResponse> holder = TransportService.this.responseHandlers.remove(this.requestId);
                if (holder != null) {
                    assert (holder.action().equals(this.action));
                    assert (holder.connection().getNode().equals(this.node));
                    holder.handler().handleException(new ReceiveTimeoutTransportException(holder.connection().getNode(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (!TransportService.this.responseHandlers.contains(this.requestId)) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }

        public String toString() {
            return "timeout handler for [" + this.requestId + "][" + this.action + "]";
        }

        private void scheduleTimeout(TimeValue timeout) {
            this.cancellable = TransportService.this.threadPool.schedule(this, timeout, TransportService.this.threadPool.generic());
        }
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportService service;
        final ThreadPool threadPool;

        DirectResponseChannel(DiscoveryNode localNode, String action, long requestId, TransportService service, ThreadPool threadPool) {
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.service = service;
            this.threadPool = threadPool;
        }

        @Override
        public String getProfileName() {
            return TransportService.DIRECT_RESPONSE_PROFILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendResponse(final TransportResponse response) throws IOException {
            try {
                this.service.onResponseSent(this.requestId, this.action, response);
                try (Releasable shutdownBlock = this.service.pendingDirectHandlers.withRef();){
                    if (shutdownBlock == null) {
                        return;
                    }
                    final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
                    if (handler == null) {
                        return;
                    }
                    Executor executor = handler.executor(this.threadPool);
                    if (executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                        this.processResponse(handler, response);
                    } else {
                        response.mustIncRef();
                        executor.execute(new ForkingResponseHandlerRunnable(handler, null, this.threadPool){

                            @Override
                            protected void doRun() {
                                this.processResponse(handler, response);
                            }

                            @Override
                            public void onAfter() {
                                response.decRef();
                            }

                            public String toString() {
                                return "delivery of response to [" + requestId + "][" + action + "]: " + response;
                            }
                        });
                    }
                }
            }
            finally {
                response.decRef();
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(final Exception exception) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, exception);
            try (Releasable shutdownBlock = this.service.pendingDirectHandlers.withRef();){
                if (shutdownBlock == null) {
                    return;
                }
                final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
                if (handler == null) {
                    return;
                }
                final RemoteTransportException rtx = this.wrapInRemote(exception);
                Executor executor = handler.executor(this.threadPool);
                if (executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                    this.processException(handler, rtx);
                } else {
                    executor.execute(new ForkingResponseHandlerRunnable(handler, rtx, this.threadPool){

                        @Override
                        protected void doRun() {
                            this.processException(handler, rtx);
                        }

                        public String toString() {
                            return "delivery of failure response to [" + requestId + "][" + action + "]: " + exception;
                        }
                    });
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Exception e) {
            RemoteTransportException remoteTransportException;
            return e instanceof RemoteTransportException ? (remoteTransportException = (RemoteTransportException)e) : new RemoteTransportException(this.localNode.getName(), this.localNode.getAddress(), this.action, (Throwable)e);
        }

        protected void processException(TransportResponseHandler<?> handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                logger.error(() -> Strings.format((String)"failed to handle exception for action [%s], handler [%s]", (Object[])new Object[]{this.action, handler}), (Throwable)e);
            }
        }

        @Override
        public String getChannelType() {
            return "direct";
        }

        public String toString() {
            return org.elasticsearch.common.Strings.format("DirectResponseChannel{req=%d}{%s}", this.requestId, this.action);
        }
    }

    record TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
    }

    public static class HandshakeResponse
    extends TransportResponse {
        private final Version version;
        private final String buildHash;
        private final DiscoveryNode discoveryNode;
        private final ClusterName clusterName;

        public HandshakeResponse(Version version, String buildHash, DiscoveryNode discoveryNode, ClusterName clusterName) {
            this.buildHash = Objects.requireNonNull(buildHash);
            this.discoveryNode = Objects.requireNonNull(discoveryNode);
            this.version = Objects.requireNonNull(version);
            this.clusterName = Objects.requireNonNull(clusterName);
        }

        public HandshakeResponse(StreamInput in) throws IOException {
            super(in);
            this.version = Version.readVersion(in);
            this.buildHash = in.readString();
            try {
                this.discoveryNode = new DiscoveryNode(in);
            }
            catch (Exception e) {
                this.maybeThrowOnIncompatibleBuild(null, e);
                throw e;
            }
            this.maybeThrowOnIncompatibleBuild(this.discoveryNode, null);
            this.clusterName = new ClusterName(in);
        }

        private void maybeThrowOnIncompatibleBuild(@Nullable DiscoveryNode node, @Nullable Exception e) {
            if (!SERVERLESS_TRANSPORT_FEATURE_FLAG && HandshakeResponse.isIncompatibleBuild(this.version, this.buildHash)) {
                this.throwOnIncompatibleBuild(node, e);
            }
        }

        private void throwOnIncompatibleBuild(@Nullable DiscoveryNode node, @Nullable Exception e) {
            throw new IllegalArgumentException("remote node [" + (node == null ? "unidentifiable" : node) + "] is build [" + this.buildHash + "] of version [" + this.version + "] but this node is build [" + Build.current().hash() + "] of version [" + Build.current().version() + "] which has an incompatible wire format", e);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Version.writeVersion(this.version, out);
            out.writeString(this.buildHash);
            this.discoveryNode.writeTo(out);
            this.clusterName.writeTo(out);
        }

        public Version getVersion() {
            return this.version;
        }

        public String getBuildHash() {
            return this.buildHash;
        }

        public DiscoveryNode getDiscoveryNode() {
            return this.discoveryNode;
        }

        public ClusterName getClusterName() {
            return this.clusterName;
        }

        private static boolean isIncompatibleBuild(Version version, String buildHash) {
            return version == Version.CURRENT && !Build.current().hash().equals(buildHash);
        }
    }
}

