/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.mapper.IgnoredFieldMapper;
import org.elasticsearch.index.mapper.LegacyTypeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public class StoredFieldsPhase
implements FetchSubPhase {
    private static final List<StoredField> METADATA_FIELDS = List.of(new StoredField("_routing", RoutingFieldMapper.FIELD_TYPE, true), new StoredField("_ignored", IgnoredFieldMapper.FIELD_TYPE, true), new StoredField("_type", LegacyTypeFieldMapper.FIELD_TYPE, true));

    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        StoredFieldsContext storedFieldsContext = fetchContext.storedFieldsContext();
        if (storedFieldsContext == null || !storedFieldsContext.fetchFields()) {
            return null;
        }
        final ArrayList<StoredField> storedFields = new ArrayList<StoredField>(METADATA_FIELDS);
        HashSet<String> fieldsToLoad = new HashSet<String>();
        if (storedFieldsContext.fieldNames() != null) {
            SearchExecutionContext sec = fetchContext.getSearchExecutionContext();
            for (String field : storedFieldsContext.fieldNames()) {
                if ("_source".equals(field)) continue;
                Set<String> fieldNames = sec.getMatchingFieldNames(field);
                for (String fieldName : fieldNames) {
                    MappedFieldType ft = sec.getFieldType(fieldName);
                    if (!ft.isStored()) continue;
                    storedFields.add(new StoredField(fieldName, ft, sec.isMetadataField(ft.name())));
                    fieldsToLoad.add(ft.name());
                }
            }
        }
        final StoredFieldsSpec storedFieldsSpec = new StoredFieldsSpec(false, true, fieldsToLoad);
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                Map<String, List<Object>> loadedFields = hitContext.loadedFields();
                HashMap<String, DocumentField> docFields = new HashMap<String, DocumentField>();
                HashMap<String, DocumentField> metaFields = new HashMap<String, DocumentField>();
                for (StoredField storedField : storedFields) {
                    if (!storedField.hasValue(loadedFields)) continue;
                    DocumentField df = new DocumentField(storedField.name, storedField.process(loadedFields));
                    if (storedField.isMetadataField) {
                        metaFields.put(storedField.name, df);
                        continue;
                    }
                    docFields.put(storedField.name, df);
                }
                hitContext.hit().addDocumentFields(docFields, metaFields);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return storedFieldsSpec;
            }
        };
    }

    private record StoredField(String name, MappedFieldType ft, boolean isMetadataField) {
        List<Object> process(Map<String, List<Object>> loadedFields) {
            List<Object> inputs = loadedFields.get(this.ft.name());
            if (inputs == null) {
                return List.of();
            }
            return inputs.stream().map(this.ft::valueForDisplay).toList();
        }

        boolean hasValue(Map<String, List<Object>> loadedFields) {
            return loadedFields.containsKey(this.ft.name());
        }
    }
}

