/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenByteKnnVectorQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenormalizedCosineFloatVectorValues;
import org.elasticsearch.index.mapper.vectors.VectorIndexFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.vectors.ProfilingDiversifyingChildrenByteKnnVectorQuery;
import org.elasticsearch.search.vectors.ProfilingDiversifyingChildrenFloatKnnVectorQuery;
import org.elasticsearch.search.vectors.ProfilingKnnByteVectorQuery;
import org.elasticsearch.search.vectors.ProfilingKnnFloatVectorQuery;
import org.elasticsearch.search.vectors.ProfilingQuery;
import org.elasticsearch.search.vectors.VectorSimilarityQuery;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DenseVectorFieldMapper
extends FieldMapper {
    public static final String COSINE_MAGNITUDE_FIELD_SUFFIX = "._magnitude";
    private static final float EPS = 1.0E-4f;
    public static final IndexVersion MAGNITUDE_STORED_INDEX_VERSION = IndexVersions.V_7_5_0;
    public static final IndexVersion INDEXED_BY_DEFAULT_INDEX_VERSION = IndexVersions.FIRST_DETACHED_INDEX_VERSION;
    public static final IndexVersion NORMALIZE_COSINE = IndexVersions.NORMALIZED_VECTOR_COSINE;
    public static final IndexVersion LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION = IndexVersions.V_8_9_0;
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)4096;
    public static short MIN_DIMS_FOR_DYNAMIC_FLOAT_MAPPING = (short)128;
    public static final int MAGNITUDE_BYTES = 4;
    static final Map<String, ElementType> namesToElementType = Map.of(ElementType.BYTE.toString(), ElementType.BYTE, ElementType.FLOAT.toString(), ElementType.FLOAT);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), DenseVectorFieldMapper.notInMultiFields("dense_vector"));
    private final IndexOptions indexOptions;
    private final IndexVersion indexCreatedVersion;

    static boolean isNotUnitVector(float magnitude) {
        return Math.abs(magnitude - 1.0f) > 1.0E-4f;
    }

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, IndexOptions indexOptions, IndexVersion indexCreatedVersion, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.indexOptions = indexOptions;
        this.indexCreatedVersion = indexCreatedVersion;
    }

    @Override
    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey(this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        if (this.fieldType().dims == null) {
            int dims = this.fieldType().elementType.parseDimensionCount(context);
            DenseVectorFieldType updatedDenseVectorFieldType = new DenseVectorFieldType(this.fieldType().name(), this.indexCreatedVersion, this.fieldType().elementType, dims, this.fieldType().indexed, this.fieldType().similarity, this.fieldType().meta());
            DenseVectorFieldMapper update = new DenseVectorFieldMapper(this.simpleName(), (MappedFieldType)updatedDenseVectorFieldType, this.indexOptions, this.indexCreatedVersion, this.multiFields(), this.copyTo);
            context.addDynamicMapper(update);
            return;
        }
        if (this.fieldType().indexed) {
            this.parseKnnVectorAndIndex(context);
        } else {
            this.parseBinaryDocValuesVectorAndIndex(context);
        }
    }

    private void parseKnnVectorAndIndex(DocumentParserContext context) throws IOException {
        this.fieldType().elementType.parseKnnVectorAndIndex(context, this);
    }

    private void parseBinaryDocValuesVectorAndIndex(DocumentParserContext context) throws IOException {
        int dims = this.fieldType().dims;
        ElementType elementType = this.fieldType().elementType;
        int numBytes = this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION) ? dims * elementType.elementBytes + 4 : dims * elementType.elementBytes;
        ByteBuffer byteBuffer = elementType.createByteBuffer(this.indexCreatedVersion, numBytes);
        double dotProduct = elementType.parseKnnVectorToByteBuffer(context, this, byteBuffer);
        if (this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION)) {
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(byteBuffer.array()));
        context.doc().addWithKey(this.fieldType().name(), (IndexableField)field);
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init(this);
    }

    private static IndexOptions parseIndexOptions(String fieldName, Object propNode) {
        Map indexOptionsMap = (Map)propNode;
        Object typeNode = indexOptionsMap.remove("type");
        if (typeNode == null) {
            throw new MapperParsingException("[index_options] requires field [type] to be configured");
        }
        String type = XContentMapValues.nodeStringValue(typeNode);
        return VectorIndexType.fromString(type).orElseThrow(() -> new MapperParsingException("Unknown vector index options type [" + type + "] for field [" + fieldName + "]")).parseIndexOptions(fieldName, indexOptionsMap);
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(KnnVectorsFormat defaultFormat) {
        final KnnVectorsFormat format = this.indexOptions == null ? defaultFormat : this.indexOptions.getVectorsFormat();
        return new KnnVectorsFormat(format.getName()){

            public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
                return format.fieldsWriter(state);
            }

            public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
                return format.fieldsReader(state);
            }

            public int getMaxDimensions(String fieldName) {
                return MAX_DIMS_COUNT;
            }

            public String toString() {
                return format.toString();
            }
        };
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        if (this.fieldType().indexed) {
            return new IndexedSyntheticFieldLoader(this.indexCreatedVersion, this.fieldType().similarity);
        }
        return new DocValuesSyntheticFieldLoader(this.indexCreatedVersion);
    }

    private static abstract class IndexOptions
    implements ToXContent {
        final String type;

        IndexOptions(String type) {
            this.type = type;
        }

        abstract KnnVectorsFormat getVectorsFormat();
    }

    public static final class DenseVectorFieldType
    extends SimpleMappedFieldType {
        private final ElementType elementType;
        private final Integer dims;
        private final boolean indexed;
        private final VectorSimilarity similarity;
        private final IndexVersion indexVersionCreated;

        public DenseVectorFieldType(String name, IndexVersion indexVersionCreated, ElementType elementType, Integer dims, boolean indexed, VectorSimilarity similarity, Map<String, String> meta) {
            super(name, indexed, false, !indexed, TextSearchInfo.NONE, meta);
            this.elementType = elementType;
            this.dims = dims;
            this.indexed = indexed;
            this.similarity = similarity;
            this.indexVersionCreated = indexVersionCreated;
        }

        @Override
        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return this.elementType.fielddataBuilder(this, fieldDataContext);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        public Query createKnnQuery(byte[] queryVector, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            Object knnQuery;
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (queryVector.length != this.dims) {
                throw new IllegalArgumentException("the query vector has a different dimension [" + queryVector.length + "] than the index vectors [" + this.dims + "]");
            }
            if (this.elementType != ElementType.BYTE) {
                throw new IllegalArgumentException("only [" + ElementType.BYTE + "] elements are supported when querying field [" + this.name() + "]");
            }
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((byte[])queryVector, (byte[])queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorByteElementsAppender(queryVector), squaredMagnitude);
            }
            Object object = knnQuery = parentFilter != null ? new DiversifyingChildrenByteKnnVectorQuery(this.name(), queryVector, filter, numCands, parentFilter) : new KnnByteVectorQuery(this.name(), queryVector, numCands, filter);
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)knnQuery, similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        public Query createKnnQuery(float[] queryVector, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            Object knnQuery;
            int i;
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (queryVector.length != this.dims) {
                throw new IllegalArgumentException("the query vector has a different dimension [" + queryVector.length + "] than the index vectors [" + this.dims + "]");
            }
            this.elementType.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((float[])queryVector, (float[])queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorFloatElementsAppender(queryVector), squaredMagnitude);
                if (this.similarity == VectorSimilarity.COSINE && ElementType.FLOAT.equals((Object)this.elementType) && this.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    queryVector = Arrays.copyOf(queryVector, queryVector.length);
                    i = 0;
                    while (i < queryVector.length) {
                        int n = i++;
                        queryVector[n] = queryVector[n] / length;
                    }
                }
            }
            switch (this.elementType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BYTE: {
                    ProfilingQuery profilingQuery;
                    byte[] bytes = new byte[queryVector.length];
                    for (i = 0; i < queryVector.length; ++i) {
                        bytes[i] = (byte)queryVector[i];
                    }
                    if (parentFilter != null) {
                        profilingQuery = new ProfilingDiversifyingChildrenByteKnnVectorQuery(this.name(), bytes, filter, numCands, parentFilter);
                        break;
                    }
                    profilingQuery = new ProfilingKnnByteVectorQuery(this.name(), bytes, numCands, filter);
                    break;
                }
                case FLOAT: {
                    ProfilingQuery profilingQuery = knnQuery = parentFilter != null ? new ProfilingDiversifyingChildrenFloatKnnVectorQuery(this.name(), queryVector, filter, numCands, parentFilter) : new ProfilingKnnFloatVectorQuery(this.name(), queryVector, numCands, filter);
                }
            }
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)knnQuery, similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        VectorSimilarity getSimilarity() {
            return this.similarity;
        }

        int getVectorDimensions() {
            return this.dims;
        }

        ElementType getElementType() {
            return this.elementType;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ElementType {
        BYTE(1){

            public String toString() {
                return "byte";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.put((byte)value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.get());
            }

            @Override
            KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                if (vector == null) {
                    throw new IllegalArgumentException("vector value must not be null");
                }
                FieldType denseVectorFieldType = new FieldType();
                denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.BYTE, function);
                denseVectorFieldType.freeze();
                return new KnnByteVectorField(name, vector, denseVectorFieldType);
            }

            @Override
            KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
                throw new IllegalArgumentException("cannot create a float vector field from byte");
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed, r -> r);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
                StringBuilder errorBuilder = null;
                for (int index = 0; index < vector.length; ++index) {
                    float value = vector[index];
                    if (value % 1.0f != 0.0f) {
                        errorBuilder = new StringBuilder("element_type [" + this + "] vectors only support non-decimal values but found decimal value [" + value + "] at dim [" + index + "];");
                        break;
                    }
                    if (!(value < -128.0f) && !(value > 127.0f)) continue;
                    errorBuilder = new StringBuilder("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(1.appendErrorElements(errorBuilder, vector).toString());
                }
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.COSINE + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                int index = 0;
                byte[] vector = new byte[fieldMapper.fieldType().dims.intValue()];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    int value;
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    if (context.parser().numberType() != XContentParser.NumberType.INT) {
                        float floatValue = context.parser().floatValue(true);
                        if (floatValue % 1.0f != 0.0f) {
                            throw new IllegalArgumentException("element_type [" + this + "] vectors only support non-decimal values but found decimal value [" + floatValue + "] at dim [" + index + "];");
                        }
                        value = (int)floatValue;
                    } else {
                        value = context.parser().intValue(true);
                    }
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    vector[index++] = (byte)value;
                    squaredMagnitude += (float)(value * value);
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorMagnitude(fieldMapper.fieldType().similarity, 1.errorByteElementsAppender(vector), squaredMagnitude);
                KnnByteVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this));
                context.doc().addWithKey(fieldMapper.fieldType().name(), (IndexableField)field);
            }

            @Override
            double parseKnnVectorToByteBuffer(DocumentParserContext context, DenseVectorFieldMapper fieldMapper, ByteBuffer byteBuffer) throws IOException {
                double dotProduct = 0.0;
                int index = 0;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    int value = context.parser().intValue(true);
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    byteBuffer.put((byte)value);
                    dotProduct += (double)(value * value);
                    ++index;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                return dotProduct;
            }

            @Override
            ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
                return ByteBuffer.wrap(new byte[numBytes]);
            }
        }
        ,
        FLOAT(4){

            public String toString() {
                return "float";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.putFloat(value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.getFloat());
            }

            @Override
            KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
                if (vector == null) {
                    throw new IllegalArgumentException("vector value must not be null");
                }
                FieldType denseVectorFieldType = new FieldType();
                denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.FLOAT32, function);
                denseVectorFieldType.freeze();
                return new KnnFloatVectorField(name, vector, denseVectorFieldType);
            }

            @Override
            KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                throw new IllegalArgumentException("cannot create a byte vector field from float");
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed, denseVectorFieldType.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && denseVectorFieldType.indexed && denseVectorFieldType.similarity.equals((Object)VectorSimilarity.COSINE) ? r -> new FilterLeafReader((LeafReader)r, (LeafReader)r){
                    final /* synthetic */ LeafReader val$r;
                    {
                        this.val$r = leafReader;
                        super(arg0);
                    }

                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return this.val$r.getCoreCacheHelper();
                    }

                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return this.val$r.getReaderCacheHelper();
                    }

                    public FloatVectorValues getFloatVectorValues(String fieldName) throws IOException {
                        FloatVectorValues values = this.in.getFloatVectorValues(fieldName);
                        if (values == null) {
                            return null;
                        }
                        return new DenormalizedCosineFloatVectorValues(values, this.in.getNumericDocValues(fieldName + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX));
                    }
                } : r -> r);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (Float.isNaN(squaredMagnitude) || Float.isInfinite(squaredMagnitude)) {
                    errorBuilder = new StringBuilder("NaN or Infinite magnitude detected, this usually means the vector values are too extreme to fit within a float.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
                if (similarity == VectorSimilarity.DOT_PRODUCT && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.DOT_PRODUCT + "] similarity can only be used with unit-length vectors.");
                } else if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.COSINE + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                int index = 0;
                float[] vector = new float[fieldMapper.fieldType().dims.intValue()];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    float value = context.parser().floatValue(true);
                    vector[index++] = value;
                    squaredMagnitude += value * value;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorBounds(vector);
                this.checkVectorMagnitude(fieldMapper.fieldType().similarity, 2.errorFloatElementsAppender(vector), squaredMagnitude);
                if (fieldMapper.indexCreatedVersion.onOrAfter(NORMALIZE_COSINE) && fieldMapper.fieldType().similarity.equals((Object)VectorSimilarity.COSINE) && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    int i = 0;
                    while (i < vector.length) {
                        int n = i++;
                        vector[n] = vector[n] / length;
                    }
                    String fieldName = fieldMapper.fieldType().name() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX;
                    FloatDocValuesField magnitudeField = new FloatDocValuesField(fieldName, length);
                    context.doc().addWithKey(fieldName, (IndexableField)magnitudeField);
                }
                KnnFloatVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this));
                context.doc().addWithKey(fieldMapper.fieldType().name(), (IndexableField)field);
            }

            @Override
            double parseKnnVectorToByteBuffer(DocumentParserContext context, DenseVectorFieldMapper fieldMapper, ByteBuffer byteBuffer) throws IOException {
                double dotProduct = 0.0;
                int index = 0;
                float[] vector = new float[fieldMapper.fieldType().dims.intValue()];
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    float value;
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    vector[index] = value = context.parser().floatValue(true);
                    byteBuffer.putFloat(value);
                    dotProduct += (double)(value * value);
                    ++index;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorBounds(vector);
                return dotProduct;
            }

            @Override
            ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
                return indexVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION) ? ByteBuffer.wrap(new byte[numBytes]).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.wrap(new byte[numBytes]);
            }
        };

        final int elementBytes;

        private ElementType(int elementBytes) {
            this.elementBytes = elementBytes;
        }

        public abstract void writeValue(ByteBuffer var1, float var2);

        public abstract void readAndWriteValue(ByteBuffer var1, XContentBuilder var2) throws IOException;

        abstract KnnFloatVectorField createKnnVectorField(String var1, float[] var2, VectorSimilarityFunction var3);

        abstract KnnByteVectorField createKnnVectorField(String var1, byte[] var2, VectorSimilarityFunction var3);

        abstract IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType var1, FieldDataContext var2);

        abstract void parseKnnVectorAndIndex(DocumentParserContext var1, DenseVectorFieldMapper var2) throws IOException;

        abstract double parseKnnVectorToByteBuffer(DocumentParserContext var1, DenseVectorFieldMapper var2, ByteBuffer var3) throws IOException;

        abstract ByteBuffer createByteBuffer(IndexVersion var1, int var2);

        public abstract void checkVectorBounds(float[] var1);

        abstract void checkVectorMagnitude(VectorSimilarity var1, Function<StringBuilder, StringBuilder> var2, float var3);

        int parseDimensionCount(DocumentParserContext context) throws IOException {
            int index = 0;
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                ++index;
                token = context.parser().nextToken();
            }
            return index;
        }

        void checkNanAndInfinite(float[] vector) {
            StringBuilder errorBuilder = null;
            for (int index = 0; index < vector.length; ++index) {
                float value = vector[index];
                if (Float.isNaN(value)) {
                    errorBuilder = new StringBuilder("element_type [" + this + "] vectors do not support NaN values but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (!Float.isInfinite(value)) continue;
                errorBuilder = new StringBuilder("element_type [" + this + "] vectors do not support infinite values but found [" + value + "] at dim [" + index + "];");
                break;
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(ElementType.appendErrorElements(errorBuilder, vector).toString());
            }
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, float[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, byte[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static Function<StringBuilder, StringBuilder> errorFloatElementsAppender(float[] vector) {
            return sb -> ElementType.appendErrorElements(sb, vector);
        }

        static Function<StringBuilder, StringBuilder> errorByteElementsAppender(byte[] vector) {
            return sb -> ElementType.appendErrorElements(sb, vector);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum VectorSimilarity {
        L2_NORM{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                switch (elementType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BYTE: 
                    case FLOAT: 
                }
                return 1.0f / (1.0f + similarity * similarity);
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
        }
        ,
        COSINE{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                switch (elementType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BYTE: 
                    case FLOAT: 
                }
                return (1.0f + similarity) / 2.0f;
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return indexVersion.onOrAfter(NORMALIZE_COSINE) && ElementType.FLOAT.equals((Object)elementType) ? VectorSimilarityFunction.DOT_PRODUCT : VectorSimilarityFunction.COSINE;
            }
        }
        ,
        DOT_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    default -> throw new IncompatibleClassChangeError();
                    case ElementType.BYTE -> 0.5f + similarity / (float)(dim * 32768);
                    case ElementType.FLOAT -> (1.0f + similarity) / 2.0f;
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
        }
        ,
        MAX_INNER_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                switch (elementType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BYTE: 
                    case FLOAT: 
                }
                return similarity < 0.0f ? 1.0f / (1.0f + -1.0f * similarity) : similarity + 1.0f;
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
            }
        };


        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        abstract float score(float var1, ElementType var2, int var3);

        public abstract VectorSimilarityFunction vectorSimilarityFunction(IndexVersion var1, ElementType var2);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<ElementType> elementType = new FieldMapper.Parameter<ElementType>("element_type", false, () -> ElementType.FLOAT, (n, c, o) -> {
            ElementType elementType = namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + o + "]; available types are " + namesToElementType.keySet());
            }
            return elementType;
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().elementType, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter<Integer>("dims", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Integer)) {
                throw new MapperParsingException("Property [dims] on field [" + n + "] must be an integer but got [" + o + "]");
            }
            int dims = XContentMapValues.nodeIntegerValue(o);
            if (dims < 1 || dims > MAX_DIMS_COUNT) {
                throw new MapperParsingException("The number of dimensions for field [" + n + "] should be in the range [1, " + MAX_DIMS_COUNT + "] but was [" + dims + "]");
            }
            return dims;
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().dims, XContentBuilder::field, Object::toString).setSerializerCheck((id, ic, v) -> v != null).setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current));
        private final FieldMapper.Parameter<VectorSimilarity> similarity;
        private final FieldMapper.Parameter<IndexOptions> indexOptions = new FieldMapper.Parameter<IndexOptions>("index_options", false, () -> null, (n, c, o) -> o == null ? null : DenseVectorFieldMapper.parseIndexOptions(n, o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexOptions, XContentBuilder::field, Objects::toString).setSerializerCheck((id, ic, v) -> v != null);
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final IndexVersion indexVersionCreated;

        public Builder(String name, IndexVersion indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            boolean indexedByDefault = indexVersionCreated.onOrAfter(INDEXED_BY_DEFAULT_INDEX_VERSION);
            this.indexed = FieldMapper.Parameter.indexParam(m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().indexed, indexedByDefault);
            if (indexedByDefault) {
                this.indexed.alwaysSerialize();
            }
            this.similarity = FieldMapper.Parameter.enumParam("similarity", false, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().similarity, () -> indexedByDefault && this.indexed.getValue() != false ? VectorSimilarity.COSINE : null, VectorSimilarity.class).acceptsNull().setSerializerCheck((id, ic, v) -> v != null);
            this.indexed.addValidator(v -> {
                if (v.booleanValue()) {
                    if (this.similarity.getValue() == null) {
                        throw new IllegalArgumentException("Field [index] requires field [similarity] to be configured and not null");
                    }
                } else {
                    if (this.similarity.isConfigured() && this.similarity.getValue() != null) {
                        throw new IllegalArgumentException("Field [similarity] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                    if (this.indexOptions.isConfigured() && this.indexOptions.getValue() != null) {
                        throw new IllegalArgumentException("Field [index_options] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                }
            });
            this.indexOptions.addValidator(v -> {
                if (v instanceof Int8HnswIndexOptions && this.elementType.getValue() == ElementType.BYTE) {
                    throw new IllegalArgumentException("[element_type] cannot be [byte] when using index type [" + VectorIndexType.INT8_HNSW.name + "]");
                }
            });
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.indexed, this.similarity, this.indexOptions, this.meta};
        }

        @Override
        public DenseVectorFieldMapper build(MapperBuilderContext context) {
            return new DenseVectorFieldMapper(this.name, (MappedFieldType)new DenseVectorFieldType(context.buildFullName(this.name), this.indexVersionCreated, this.elementType.getValue(), this.dims.getValue(), this.indexed.getValue(), this.similarity.getValue(), this.meta.getValue()), this.indexOptions.getValue(), this.indexVersionCreated, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum VectorIndexType {
        HNSW("hnsw"){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new HnswIndexOptions(m, efConstruction);
            }
        }
        ,
        INT8_HNSW("int8_hnsw"){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int8HnswIndexOptions(m, efConstruction, confidenceInterval);
            }
        };

        private final String name;

        static Optional<VectorIndexType> fromString(String type) {
            return Stream.of(VectorIndexType.values()).filter(vectorIndexType -> vectorIndexType.name.equals(type)).findFirst();
        }

        private VectorIndexType(String name) {
            this.name = name;
        }

        abstract IndexOptions parseIndexOptions(String var1, Map<String, ?> var2);
    }

    private class IndexedSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private FloatVectorValues values;
        private ByteVectorValues byteVectorValues;
        private boolean hasValue;
        private boolean hasMagnitude;
        private final IndexVersion indexCreatedVersion;
        private final VectorSimilarity vectorSimilarity;
        private NumericDocValues magnitudeReader;

        private IndexedSyntheticFieldLoader(IndexVersion indexCreatedVersion, VectorSimilarity vectorSimilarity) {
            this.indexCreatedVersion = indexCreatedVersion;
            this.vectorSimilarity = vectorSimilarity;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getFloatVectorValues(DenseVectorFieldMapper.this.name());
            if (this.values != null) {
                if (this.indexCreatedVersion.onOrAfter(NORMALIZE_COSINE) && VectorSimilarity.COSINE.equals((Object)this.vectorSimilarity)) {
                    this.magnitudeReader = leafReader.getNumericDocValues(DenseVectorFieldMapper.this.name() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX);
                }
                return docId -> {
                    this.hasValue = docId == this.values.advance(docId);
                    this.hasMagnitude = this.hasValue && this.magnitudeReader != null && this.magnitudeReader.advanceExact(docId);
                    return this.hasValue;
                };
            }
            this.byteVectorValues = leafReader.getByteVectorValues(DenseVectorFieldMapper.this.name());
            if (this.byteVectorValues != null) {
                return docId -> {
                    this.hasValue = docId == this.byteVectorValues.advance(docId);
                    return this.hasValue;
                };
            }
            return null;
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            float magnitude = Float.NaN;
            if (this.hasMagnitude) {
                magnitude = Float.intBitsToFloat((int)this.magnitudeReader.longValue());
            }
            b.startArray(DenseVectorFieldMapper.this.simpleName());
            if (this.values != null) {
                for (float v : this.values.vectorValue()) {
                    if (this.hasMagnitude) {
                        b.value(v * magnitude);
                        continue;
                    }
                    b.value(v);
                }
            } else if (this.byteVectorValues != null) {
                byte[] vectorValue;
                for (byte value : vectorValue = this.byteVectorValues.vectorValue()) {
                    b.value(value);
                }
            }
            b.endArray();
        }
    }

    private class DocValuesSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;
        private final IndexVersion indexCreatedVersion;

        private DocValuesSyntheticFieldLoader(IndexVersion indexCreatedVersion) {
            this.indexCreatedVersion = indexCreatedVersion;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(DenseVectorFieldMapper.this.name());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                this.hasValue = docId == this.values.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(DenseVectorFieldMapper.this.simpleName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length);
            if (this.indexCreatedVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION)) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int dims = DenseVectorFieldMapper.this.fieldType().dims;
            for (int dim = 0; dim < dims; ++dim) {
                DenseVectorFieldMapper.this.fieldType().elementType.readAndWriteValue(byteBuffer, b);
            }
            b.endArray();
        }
    }

    private static class HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;

        private HnswIndexOptions(int m, int efConstruction) {
            super("hnsw");
            this.m = m;
            this.efConstruction = efConstruction;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat() {
            return new Lucene99HnswVectorsFormat(this.m, this.efConstruction, 1, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HnswIndexOptions that = (HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.m, this.efConstruction);
        }

        public String toString() {
            return "{type=" + this.type + ", m=" + this.m + ", ef_construction=" + this.efConstruction + "}";
        }
    }

    private static class Int8HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;
        private final Float confidenceInterval;

        private Int8HnswIndexOptions(int m, int efConstruction, Float confidenceInterval) {
            super("int8_hnsw");
            this.m = m;
            this.efConstruction = efConstruction;
            this.confidenceInterval = confidenceInterval;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat() {
            return new Lucene99HnswScalarQuantizedVectorsFormat(this.m, this.efConstruction, 1, this.confidenceInterval, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            if (this.confidenceInterval != null) {
                builder.field("confidence_interval", this.confidenceInterval);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Int8HnswIndexOptions that = (Int8HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(this.confidenceInterval, that.confidenceInterval);
        }

        public int hashCode() {
            return Objects.hash(this.m, this.efConstruction, this.confidenceInterval);
        }

        public String toString() {
            return "{type=" + this.type + ", m=" + this.m + ", ef_construction=" + this.efConstruction + ", confidence_interval=" + this.confidenceInterval + "}";
        }
    }
}

