/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.Strings;

public class MapperBuilderContext {
    private final String path;
    private final boolean isSourceSynthetic;
    private final boolean isDataStream;

    public static MapperBuilderContext root(boolean isSourceSynthetic, boolean isDataStream) {
        return new MapperBuilderContext(null, isSourceSynthetic, isDataStream);
    }

    MapperBuilderContext(String path, boolean isSourceSynthetic, boolean isDataStream) {
        this.path = path;
        this.isSourceSynthetic = isSourceSynthetic;
        this.isDataStream = isDataStream;
    }

    public MapperBuilderContext createChildContext(String name) {
        return new MapperBuilderContext(this.buildFullName(name), this.isSourceSynthetic, this.isDataStream);
    }

    public String buildFullName(String name) {
        if (Strings.isEmpty(this.path)) {
            return name;
        }
        return this.path + "." + name;
    }

    public boolean isSourceSynthetic() {
        return this.isSourceSynthetic;
    }

    public boolean isDataStream() {
        return this.isDataStream;
    }
}

