/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.DateTimeException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.BooleanScriptFieldType;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DateScriptFieldType;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DoubleScriptFieldType;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.KeywordScriptFieldType;
import org.elasticsearch.index.mapper.LongScriptFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.xcontent.XContentParser;

final class DynamicFieldsBuilder {
    private static final Concrete CONCRETE = new Concrete(DocumentParser::parseObjectOrField);
    static final DynamicFieldsBuilder DYNAMIC_TRUE = new DynamicFieldsBuilder(CONCRETE);
    static final DynamicFieldsBuilder DYNAMIC_RUNTIME = new DynamicFieldsBuilder(new Runtime());
    private final Strategy strategy;

    private DynamicFieldsBuilder(Strategy strategy) {
        this.strategy = strategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createDynamicFieldFromValue(DocumentParserContext context, String name) throws IOException {
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            String text = context.parser().text();
            boolean parseableAsLong = false;
            try {
                Long.parseLong(text);
                parseableAsLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean parseableAsDouble = false;
            try {
                Double.parseDouble(text);
                parseableAsDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parseableAsLong && context.root().numericDetection()) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
                return;
            }
            if (parseableAsDouble && context.root().numericDetection()) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
                return;
            }
            if (!parseableAsLong && !parseableAsDouble && context.root().dateDetection()) {
                for (DateFormatter dateTimeFormatter : context.root().dynamicDateTimeFormatters()) {
                    try {
                        dateTimeFormatter.parseMillis(text);
                    }
                    catch (IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                        continue;
                    }
                    DynamicFieldsBuilder.createDynamicDateField(context, name, dateTimeFormatter, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDateField(context, name, dateTimeFormatter)));
                    return;
                }
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicStringField(context, name)));
                return;
            }
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicStringField(context, name)));
            return;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.BIG_INTEGER) {
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.LONG, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicLongField(context, name)));
                return;
            } else {
                if (numberType != XContentParser.NumberType.FLOAT && numberType != XContentParser.NumberType.DOUBLE && numberType != XContentParser.NumberType.BIG_DECIMAL) throw new IllegalStateException("Unable to parse number of type [" + numberType + "]");
                DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DOUBLE, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicDoubleField(context, name)));
            }
            return;
        } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BOOLEAN, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.strategy.newDynamicBooleanField(context, name)));
            return;
        } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.BINARY, (CheckedRunnable<IOException>)((CheckedRunnable)() -> CONCRETE.newDynamicBinaryField(context, name)));
            return;
        } else {
            DynamicFieldsBuilder.createDynamicStringFieldFromTemplate(context, name);
        }
    }

    static Mapper createDynamicObjectMapper(DocumentParserContext context, String name) {
        Mapper mapper = DynamicFieldsBuilder.createObjectMapperFromTemplate(context, name);
        return mapper != null ? mapper : new ObjectMapper.Builder(name, ObjectMapper.Defaults.SUBOBJECTS).enabled(true).build(context.createDynamicMapperBuilderContext());
    }

    static Mapper createObjectMapperFromTemplate(DocumentParserContext context, String name) {
        Mapper.Builder templateBuilder = DynamicFieldsBuilder.findTemplateBuilderForObject(context, name);
        return templateBuilder == null ? null : templateBuilder.build(context.createDynamicMapperBuilderContext());
    }

    static void createDynamicStringFieldFromTemplate(DocumentParserContext context, String name) throws IOException {
        DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.STRING, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {}));
    }

    private static void createDynamicDateField(DocumentParserContext context, String name, DateFormatter dateFormatter, CheckedRunnable<IOException> createDynamicField) throws IOException {
        DynamicFieldsBuilder.createDynamicField(context, name, DynamicTemplate.XContentFieldType.DATE, dateFormatter, createDynamicField);
    }

    private static void createDynamicField(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, CheckedRunnable<IOException> dynamicFieldStrategy) throws IOException {
        assert (matchType != DynamicTemplate.XContentFieldType.DATE);
        DynamicFieldsBuilder.createDynamicField(context, name, matchType, null, dynamicFieldStrategy);
    }

    private static void createDynamicField(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter, CheckedRunnable<IOException> dynamicFieldStrategy) throws IOException {
        if (DynamicFieldsBuilder.applyMatchingTemplate(context, name, matchType, dateFormatter)) {
            context.markFieldAsAppliedFromTemplate(name);
        } else {
            dynamicFieldStrategy.run();
        }
    }

    private static boolean applyMatchingTemplate(DocumentParserContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormatter) throws IOException {
        DynamicTemplate dynamicTemplate = context.findDynamicTemplate(name, matchType);
        if (dynamicTemplate == null) {
            return false;
        }
        String dynamicType = dynamicTemplate.isRuntimeMapping() ? matchType.defaultRuntimeMappingType() : matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        if (dynamicTemplate.isRuntimeMapping()) {
            MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
            RuntimeField.Parser parser = parserContext.runtimeFieldParser(mappingType);
            String fullName = context.path().pathAsText(name);
            if (parser == null) {
                throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + fullName + "]");
            }
            RuntimeField.Builder builder = parser.parse(fullName, mapping, parserContext);
            Runtime.createDynamicField(builder.createRuntimeField(parserContext), context);
        } else {
            Mapper.Builder builder = DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, dateFormatter, context);
            CONCRETE.createDynamicField(builder, context);
        }
        return true;
    }

    private static Mapper.Builder findTemplateBuilderForObject(DocumentParserContext context, String name) {
        DynamicTemplate.XContentFieldType matchType = DynamicTemplate.XContentFieldType.OBJECT;
        DynamicTemplate dynamicTemplate = context.findDynamicTemplate(name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        String dynamicType = matchType.defaultMappingType();
        String mappingType = dynamicTemplate.mappingType(dynamicType);
        Map<String, Object> mapping = dynamicTemplate.mappingForName(name, dynamicType);
        return DynamicFieldsBuilder.parseDynamicTemplateMapping(name, mappingType, mapping, null, context);
    }

    private static Mapper.Builder parseDynamicTemplateMapping(String name, String mappingType, Map<String, Object> mapping, DateFormatter dateFormatter, DocumentParserContext context) {
        MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, mapping, parserContext);
    }

    private static interface Strategy {
        public void newDynamicStringField(DocumentParserContext var1, String var2) throws IOException;

        public void newDynamicLongField(DocumentParserContext var1, String var2) throws IOException;

        public void newDynamicDoubleField(DocumentParserContext var1, String var2) throws IOException;

        public void newDynamicBooleanField(DocumentParserContext var1, String var2) throws IOException;

        public void newDynamicDateField(DocumentParserContext var1, String var2, DateFormatter var3) throws IOException;
    }

    private static final class Runtime
    implements Strategy {
        private Runtime() {
        }

        static void createDynamicField(RuntimeField runtimeField, DocumentParserContext context) {
            context.addDynamicRuntimeField(runtimeField);
        }

        @Override
        public void newDynamicStringField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            Runtime.createDynamicField(KeywordScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public void newDynamicLongField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            Runtime.createDynamicField(LongScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public void newDynamicDoubleField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            Runtime.createDynamicField(DoubleScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public void newDynamicBooleanField(DocumentParserContext context, String name) {
            String fullName = context.path().pathAsText(name);
            Runtime.createDynamicField(BooleanScriptFieldType.sourceOnly(fullName), context);
        }

        @Override
        public void newDynamicDateField(DocumentParserContext context, String name, DateFormatter dateFormatter) {
            String fullName = context.path().pathAsText(name);
            MappingParserContext parserContext = context.dynamicTemplateParserContext(dateFormatter);
            Runtime.createDynamicField(DateScriptFieldType.sourceOnly(fullName, dateFormatter, parserContext.indexVersionCreated()), context);
        }
    }

    private static final class Concrete
    implements Strategy {
        private final CheckedBiConsumer<DocumentParserContext, Mapper, IOException> parseField;

        Concrete(CheckedBiConsumer<DocumentParserContext, Mapper, IOException> parseField) {
            this.parseField = parseField;
        }

        void createDynamicField(Mapper.Builder builder, DocumentParserContext context) throws IOException {
            Mapper mapper = builder.build(context.createDynamicMapperBuilderContext());
            context.addDynamicMapper(mapper);
            this.parseField.accept(context, mapper);
        }

        @Override
        public void newDynamicStringField(DocumentParserContext context, String name) throws IOException {
            this.createDynamicField(new TextFieldMapper.Builder(name, context.indexAnalyzers()).addMultiField(new KeywordFieldMapper.Builder("keyword", context.indexSettings().getIndexVersionCreated()).ignoreAbove(256)), context);
        }

        @Override
        public void newDynamicLongField(DocumentParserContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, ScriptCompiler.NONE, context.indexSettings().getSettings(), context.indexSettings().getIndexVersionCreated(), context.indexSettings().getMode()), context);
        }

        @Override
        public void newDynamicDoubleField(DocumentParserContext context, String name) throws IOException {
            this.createDynamicField(new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, ScriptCompiler.NONE, context.indexSettings().getSettings(), context.indexSettings().getIndexVersionCreated(), context.indexSettings().getMode()), context);
        }

        @Override
        public void newDynamicBooleanField(DocumentParserContext context, String name) throws IOException {
            Settings settings = context.indexSettings().getSettings();
            boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(settings);
            this.createDynamicField(new BooleanFieldMapper.Builder(name, ScriptCompiler.NONE, ignoreMalformed, context.indexSettings().getIndexVersionCreated()), context);
        }

        @Override
        public void newDynamicDateField(DocumentParserContext context, String name, DateFormatter dateTimeFormatter) throws IOException {
            Settings settings = context.indexSettings().getSettings();
            boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(settings);
            this.createDynamicField(new DateFieldMapper.Builder(name, DateFieldMapper.Resolution.MILLISECONDS, dateTimeFormatter, ScriptCompiler.NONE, ignoreMalformed, context.indexSettings().getIndexVersionCreated()), context);
        }

        void newDynamicBinaryField(DocumentParserContext context, String name) throws IOException {
            this.createDynamicField(new BinaryFieldMapper.Builder(name), context);
        }
    }
}

