/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.Writeable;

public class NamedWriteableRegistry {
    private final Map<Class<?>, Map<String, Writeable.Reader<?>>> registry;

    public NamedWriteableRegistry(List<Entry> entries) {
        if (entries.isEmpty()) {
            this.registry = Map.of();
            return;
        }
        entries = new ArrayList<Entry>(entries);
        entries.sort(Comparator.comparing(e -> e.categoryClass.getName()));
        HashMap registry = new HashMap();
        HashMap readers = null;
        Class<?> currentCategory = null;
        for (Entry entry : entries) {
            Writeable.Reader<?> oldReader;
            if (currentCategory != entry.categoryClass) {
                if (currentCategory != null) {
                    registry.put(currentCategory, Map.copyOf(readers));
                }
                readers = new HashMap();
                currentCategory = entry.categoryClass;
            }
            if ((oldReader = readers.put(entry.name, entry.reader)) == null) continue;
            throw new IllegalArgumentException("NamedWriteable [" + currentCategory.getName() + "][" + entry.name + "] is already registered for [" + oldReader.getClass().getName() + "], cannot register [" + entry.reader.getClass().getName() + "]");
        }
        registry.put(currentCategory, Map.copyOf(readers));
        this.registry = Map.copyOf(registry);
    }

    public <T> Writeable.Reader<? extends T> getReader(Class<T> categoryClass, String name) {
        Map<String, Writeable.Reader<?>> readers = this.getReaders(categoryClass);
        return NamedWriteableRegistry.getReader(categoryClass, name, readers);
    }

    public static <T> Writeable.Reader<? extends T> getReader(Class<T> categoryClass, String name, Map<String, Writeable.Reader<?>> readers) {
        Writeable.Reader<?> reader = readers.get(name);
        if (reader == null) {
            NamedWriteableRegistry.throwOnUnknownWritable(categoryClass, name);
        }
        return reader;
    }

    public <T> Map<String, Writeable.Reader<?>> getReaders(Class<T> categoryClass) {
        Map<String, Writeable.Reader<?>> readers = this.registry.get(categoryClass);
        if (readers == null) {
            NamedWriteableRegistry.throwOnUnknownCategory(categoryClass);
        }
        return readers;
    }

    private static <T> void throwOnUnknownWritable(Class<T> categoryClass, String name) {
        throw new IllegalArgumentException("Unknown NamedWriteable [" + categoryClass.getName() + "][" + name + "]");
    }

    private static <T> void throwOnUnknownCategory(Class<T> categoryClass) {
        throw new IllegalArgumentException("Unknown NamedWriteable category [" + categoryClass.getName() + "]");
    }

    public static class Entry {
        public final Class<?> categoryClass;
        public final String name;
        public final Writeable.Reader<?> reader;

        public <T extends NamedWriteable> Entry(Class<T> categoryClass, String name, Writeable.Reader<? extends T> reader) {
            this.categoryClass = Objects.requireNonNull(categoryClass);
            this.name = Objects.requireNonNull(name);
            this.reader = Objects.requireNonNull(reader);
        }
    }
}

